/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.metrics.Metrics;
import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Meter;
import java.util.Objects;

public class MetricsCollector {
    private final Metrics metrics;
    private final String identifierPrefix;
    private final Meter totalNumberOfReceivedMessages;
    private final Meter totalNumberOfUnparsabledMessagesReceived;
    private final Meter totalNumberOfSentMessages;
    private final Counter totalNumberOfSubscriptions;

    public MetricsCollector(Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.metrics = metrics;
        this.identifierPrefix = Metrics.name((String)"websocket", (String[])new String[0]).toString();
        this.totalNumberOfReceivedMessages = metrics.getMeter(this.identifierPrefix, new String[]{"received", "total"});
        this.totalNumberOfUnparsabledMessagesReceived = metrics.getMeter(this.identifierPrefix, new String[]{"received", "unparsable", "total"});
        this.totalNumberOfSentMessages = metrics.getMeter(this.identifierPrefix, new String[]{"sent", "total"});
        this.totalNumberOfSubscriptions = metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", "total"});
    }

    public void messageReceived(String destination) {
        this.metrics.getMeter(this.identifierPrefix, new String[]{"received", destination}).mark();
        this.totalNumberOfReceivedMessages.mark();
    }

    public void unparsableMessageReceived(String destination) {
        this.metrics.getMeter(this.identifierPrefix, new String[]{"received", "unparsable", destination}).mark();
        this.totalNumberOfUnparsabledMessagesReceived.mark();
    }

    public void messageSent(String destination) {
        this.metrics.getMeter(this.identifierPrefix, new String[]{"sent", destination}).mark();
        this.totalNumberOfSentMessages.mark();
    }

    public void subscriptionCreated(String destination) {
        this.metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", destination}).inc();
        this.totalNumberOfSubscriptions.inc();
    }

    public void subscriptionDestroyed(String destination) {
        this.metrics.getCounter(this.identifierPrefix, new String[]{"subscriptions", destination}).dec();
        this.totalNumberOfSubscriptions.dec();
    }
}

