/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.client;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSourceFactory;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.SendAction;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpoint;
import ch.squaredesk.nova.comm.websockets.client.StreamCreatingWebSocketTextListener;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import io.reactivex.functions.Function;
import java.util.function.Consumer;

public class ClientEndpointFactory {
    private final MessageTranscriber<String> messageTranscriber;

    public ClientEndpointFactory(MessageTranscriber<String> messageTranscriber) {
        this.messageTranscriber = messageTranscriber;
    }

    public ClientEndpoint createFor(AsyncHttpClient httpClient, String destination, MetricsCollector metricsCollector) {
        StreamCreatingWebSocketTextListener listener = new StreamCreatingWebSocketTextListener();
        WebSocketUpgradeHandler webSocketUpgradeHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)listener).build();
        com.ning.http.client.ws.WebSocket underlyingWebSocket = ClientEndpointFactory.openConnection(httpClient, destination, webSocketUpgradeHandler);
        WebSocket webSocket = this.createWebSocket(destination, underlyingWebSocket, metricsCollector);
        Function webSocketFactory = rawSocket -> webSocket;
        EndpointStreamSource endpointStreamSource = EndpointStreamSourceFactory.createStreamSourceFor(destination, webSocketFactory, listener, metricsCollector);
        Consumer<CloseReason> closeAction = closeReason -> {
            if (underlyingWebSocket instanceof GrizzlyWebSocketAdapter) {
                GrizzlyWebSocketAdapter gwsa = (GrizzlyWebSocketAdapter)underlyingWebSocket;
                gwsa.getGrizzlyWebSocket().close(closeReason.code, closeReason.text);
            } else {
                underlyingWebSocket.close();
            }
            listener.close();
        };
        return new ClientEndpoint(destination, endpointStreamSource, webSocket, closeAction, this.messageTranscriber, metricsCollector);
    }

    private static com.ning.http.client.ws.WebSocket openConnection(AsyncHttpClient httpClient, String destination, WebSocketUpgradeHandler webSocketUpgradeHandler) {
        try {
            return (com.ning.http.client.ws.WebSocket)httpClient.prepareGet(destination).execute((AsyncHandler)webSocketUpgradeHandler).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to connect to " + destination, e);
        }
    }

    private WebSocket createWebSocket(final String destination, final com.ning.http.client.ws.WebSocket webSocket, final MetricsCollector metricsCollector) {
        SendAction sendAction = new SendAction(){

            @Override
            public <T> void accept(T message) throws Exception {
                String messageAsString = (String)ClientEndpointFactory.this.messageTranscriber.getOutgoingMessageTranscriber(message).apply(message);
                webSocket.sendMessage(messageAsString);
                metricsCollector.messageSent(destination);
            }
        };
        Runnable closeAction = () -> metricsCollector.subscriptionDestroyed(destination);
        return new WebSocket(sendAction, closeAction);
    }

    private static <MessageType> MessageType unmarshal(String destination, String message, Function<String, MessageType> messageUnmarshaller, MetricsCollector metricsCollector) {
        try {
            return (MessageType)messageUnmarshaller.apply((Object)message);
        }
        catch (Exception e) {
            metricsCollector.unparsableMessageReceived(destination);
            throw new RuntimeException("Unable to unmarshal incoming message " + message + " on destination " + destination, e);
        }
    }
}

