/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjssr.renderer.assets;

import ch.swaechter.angularjssr.renderer.assets.RenderAssetProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;

public class ResourceProvider
implements RenderAssetProvider {
    private final String indexcontent;
    private final File serverbundle;

    public ResourceProvider(InputStream indexinputstream, InputStream serverbundleinputstream, Charset charset) throws IOException {
        this.indexcontent = this.getIndexContent(indexinputstream, charset);
        this.serverbundle = this.getServerBundle(serverbundleinputstream);
    }

    @Override
    public String getIndexContent() throws IOException {
        return this.indexcontent;
    }

    @Override
    public File getServerBundle() throws IOException {
        return this.serverbundle;
    }

    @Override
    public boolean isLiveReloadSupported() {
        return false;
    }

    @Override
    public boolean isLiveReloadRequired(Date date) {
        return false;
    }

    private String getIndexContent(InputStream inputstream, Charset charset) throws IOException {
        ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
        int result = inputstream.read();
        while (result != -1) {
            outputstream.write((byte)result);
            result = inputstream.read();
        }
        return outputstream.toString(charset.name());
    }

    private File getServerBundle(InputStream inputstream) throws IOException {
        File file = File.createTempFile("serverbundle", ".js");
        FileOutputStream outputstream = new FileOutputStream(file);
        int result = inputstream.read();
        while (result != -1) {
            ((OutputStream)outputstream).write((byte)result);
            result = inputstream.read();
        }
        return file;
    }
}

