/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjssr.renderer.queue;

import ch.swaechter.angularjssr.renderer.queue.RenderFuture;
import ch.swaechter.angularjssr.renderer.queue.RenderRequest;
import ch.swaechter.angularjssr.renderer.queue.RenderResponse;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class RenderQueue {
    private final List<RenderFuture> futures = new LinkedList<RenderFuture>();

    public boolean isQueuePending() {
        return this.futures.size() == 0;
    }

    public RenderFuture createRenderFuture(String uri) {
        RenderFuture future = new RenderFuture(new RenderRequest(uri));
        this.futures.add(future);
        return future;
    }

    public Optional<RenderRequest> getNextRenderRequest() {
        Optional<RenderFuture> futureitem = this.futures.stream().filter(future -> !future.isRendering()).findFirst();
        if (futureitem.isPresent()) {
            RenderFuture future2 = futureitem.get();
            RenderRequest request = future2.getRequest();
            future2.setRendering();
            return Optional.of(request);
        }
        return Optional.empty();
    }

    public void resolveRenderFuture(RenderResponse response) {
        Optional<RenderFuture> futureitem = this.futures.stream().filter(i -> i.getRequest().getUuid().equals(response.getUuid())).findFirst();
        if (futureitem.isPresent()) {
            RenderFuture future = futureitem.get();
            this.futures.remove(future);
            future.getCompletableFuture().complete(response.getContent());
        }
    }
}

