/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjuniversal.v8renderer;

import ch.swaechter.angularjuniversal.renderer.assets.RenderAssetProvider;
import ch.swaechter.angularjuniversal.renderer.engine.RenderEngine;
import ch.swaechter.angularjuniversal.renderer.queue.RenderQueue;
import ch.swaechter.angularjuniversal.renderer.queue.RenderRequest;
import ch.swaechter.angularjuniversal.renderer.queue.RenderResponse;
import ch.swaechter.angularjuniversal.v8renderer.V8Utils;
import com.eclipsesource.v8.NodeJS;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.MemoryManager;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class V8RenderEngine
implements RenderEngine {
    private MemoryManager memorymanager;
    private NodeJS nodejs;
    private V8Object renderfunction;
    private V8Object rendermodule;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(RenderQueue queue, RenderAssetProvider provider) {
        try {
            String functioncontent = V8Utils.getContentFromInputStream(this.getClass().getResourceAsStream("/Function.js"), StandardCharsets.UTF_8);
            this.running = true;
            this.nodejs = NodeJS.createNodeJS();
            this.memorymanager = new MemoryManager(this.nodejs.getRuntime());
            this.nodejs.getRuntime().registerJavaMethod((v8Object, v8Array) -> {
                this.renderfunction = v8Array.getObject(0);
                this.rendermodule = v8Array.getObject(1);
            }, "registerRenderElements");
            this.nodejs.getRuntime().registerJavaMethod((v8Object, v8Array) -> {
                String uuid = v8Array.getString(0);
                String html = v8Array.getString(1);
                V8Object error = v8Array.getObject(2);
                if (error == null) {
                    queue.resolveRenderFuture(new RenderResponse(uuid, html));
                } else {
                    System.err.println("The V8 render received a render response with an error for " + uuid + ": " + error);
                }
            }, "receiveRenderedPage");
            this.nodejs.getRuntime().executeScript(functioncontent);
            this.nodejs.exec(provider.getServerBundle());
            while (this.running) {
                this.nodejs.handleMessage();
                Optional requestitem = queue.getNextRenderRequest();
                if (!requestitem.isPresent()) continue;
                RenderRequest request = (RenderRequest)requestitem.get();
                V8Array parameters = new V8Array(this.nodejs.getRuntime());
                try {
                    parameters.push((V8Value)this.renderfunction);
                    parameters.push((V8Value)this.rendermodule);
                    parameters.push(request.getUuid());
                    parameters.push(provider.getIndexContent());
                    parameters.push(request.getUri());
                    this.nodejs.getRuntime().executeVoidFunction("renderPage", parameters);
                }
                finally {
                    parameters.release();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (this.memorymanager != null) {
                this.memorymanager.release();
            }
            if (this.nodejs != null) {
                this.nodejs.release();
            }
        }
    }

    public void stopWork() {
        this.running = false;
    }

    public boolean isWorking() {
        return this.running;
    }
}

