/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjuniversal.v8renderer;

import ch.swaechter.angularjuniversal.renderer.configuration.RenderConfiguration;
import ch.swaechter.angularjuniversal.renderer.engine.RenderEngine;
import ch.swaechter.angularjuniversal.renderer.request.RenderRequest;
import com.eclipsesource.v8.NodeJS;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.utils.MemoryManager;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public class V8RenderEngine
implements RenderEngine {
    private RenderRequest currentrenderrequest;
    private NodeJS nodejs;
    private MemoryManager memorymanager;
    private V8Object renderadapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWorking(BlockingQueue<Optional<RenderRequest>> renderrequests, RenderConfiguration renderconfiguration) {
        try {
            this.nodejs = NodeJS.createNodeJS();
            this.memorymanager = new MemoryManager(this.nodejs.getRuntime());
            this.nodejs.getRuntime().registerJavaMethod((v8Object, v8Array) -> {
                this.renderadapter = v8Array.getObject(0);
            }, "registerRenderAdapter");
            this.nodejs.getRuntime().registerJavaMethod((v8Object, v8Array) -> {
                String uuid = v8Array.getString(0);
                String html = v8Array.getString(1);
                V8Object error = v8Array.getObject(2);
                if (error == null) {
                    this.currentrenderrequest.getFuture().complete(html);
                } else {
                    System.err.println("The V8 render received a render response with an error for " + uuid + ": " + error);
                }
            }, "receiveRenderedPage");
            this.nodejs.exec(renderconfiguration.getServerBundleFile());
            this.nodejs.handleMessage();
            V8Array parameters = new V8Array(this.nodejs.getRuntime());
            parameters.push(renderconfiguration.getTemplateContent());
            this.renderadapter.executeVoidFunction("setHtml", parameters);
            parameters.release();
            while (true) {
                this.nodejs.handleMessage();
                Optional<RenderRequest> renderrequest = renderrequests.take();
                if (renderrequest.isPresent()) {
                    this.currentrenderrequest = renderrequest.get();
                    parameters = new V8Array(this.nodejs.getRuntime());
                    parameters.push(this.currentrenderrequest.getUuid());
                    parameters.push(this.currentrenderrequest.getUri());
                    this.renderadapter.executeVoidFunction("renderPage", parameters);
                    while (!this.currentrenderrequest.getFuture().isDone()) {
                        this.nodejs.handleMessage();
                    }
                    parameters.release();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
        finally {
            if (this.memorymanager != null) {
                this.memorymanager.release();
            }
            if (this.nodejs != null) {
                this.nodejs.release();
            }
        }
    }
}

