/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjuniversal.renderer.assets;

import ch.swaechter.angularjuniversal.renderer.assets.RenderAssetProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;

public class FilesystemProvider
implements RenderAssetProvider {
    private final File indexfile;
    private final File serverbundlefile;
    private final Charset charset;

    public FilesystemProvider(File indexfile, File serverbundlefile, Charset charset) throws IOException {
        this.indexfile = indexfile;
        this.serverbundlefile = serverbundlefile;
        this.charset = charset;
    }

    @Override
    public String getIndexContent() throws IOException {
        FileInputStream inputstream = new FileInputStream(this.indexfile);
        ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
        int result = ((InputStream)inputstream).read();
        while (result != -1) {
            outputstream.write((byte)result);
            result = ((InputStream)inputstream).read();
        }
        return outputstream.toString(this.charset.name());
    }

    @Override
    public File getServerBundle() throws IOException {
        return this.serverbundlefile;
    }

    @Override
    public boolean isLiveReloadSupported() {
        return true;
    }

    @Override
    public boolean isLiveReloadRequired(Date date) throws IOException {
        return this.isFileOutdated(this.indexfile, date) || this.isFileOutdated(this.serverbundlefile, date);
    }

    private boolean isFileOutdated(File file, Date date) throws IOException {
        return date.before(new Date(file.lastModified()));
    }
}

