/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjuniversal.renderer;

import ch.swaechter.angularjuniversal.renderer.configuration.RenderConfiguration;
import ch.swaechter.angularjuniversal.renderer.engine.RenderEngine;
import ch.swaechter.angularjuniversal.renderer.engine.RenderEngineFactory;
import ch.swaechter.angularjuniversal.renderer.request.RenderRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;

public class Renderer {
    private final RenderEngineFactory renderenginefactory;
    private final List<RenderEngine> renderengines;
    private final BlockingQueue<Optional<RenderRequest>> renderrequests;
    private final RenderConfiguration renderconfiguration;
    private Date startdate;

    public Renderer(RenderEngineFactory renderenginefactory, RenderConfiguration renderconfiguration) {
        this.renderenginefactory = renderenginefactory;
        this.renderengines = new ArrayList<RenderEngine>();
        this.renderrequests = new LinkedBlockingDeque<Optional<RenderRequest>>();
        this.renderconfiguration = renderconfiguration;
    }

    public synchronized void startRenderer() {
        if (this.renderengines.size() != 0) {
            return;
        }
        this.startdate = new Date();
        for (int i = 0; i < this.renderconfiguration.getEngines(); ++i) {
            RenderEngine renderengine = this.renderenginefactory.createRenderEngine();
            this.renderengines.add(renderengine);
            Thread thread = new Thread(() -> renderengine.startWorking(this.renderrequests, this.renderconfiguration));
            thread.start();
        }
        if (this.renderconfiguration.getLiveReload()) {
            Thread thread = new Thread(() -> {
                while (this.isRendererRunning()) {
                    File file = this.renderconfiguration.getServerBundleFile();
                    if (!this.startdate.before(new Date(file.lastModified()))) continue;
                    this.stopRenderer();
                    this.startRenderer();
                }
            });
            thread.start();
        }
    }

    public synchronized void stopRenderer() {
        if (this.renderengines.size() == 0) {
            return;
        }
        for (int i = 0; i < this.renderconfiguration.getEngines(); ++i) {
            this.renderrequests.add(Optional.empty());
        }
        while (this.renderrequests.size() != 0) {
        }
        this.renderengines.clear();
    }

    public synchronized boolean isRendererRunning() {
        return this.renderengines.size() != 0;
    }

    public Future<String> addRenderRequest(String uri) {
        RenderRequest renderrequest = new RenderRequest(uri);
        this.renderrequests.add(Optional.of(renderrequest));
        return renderrequest.getFuture();
    }
}

