/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.angularjuniversal.renderer.configuration;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class RenderConfiguration {
    private final String templatecontent;
    private final File serverbundlefile;
    private final int engines;
    private final boolean livereload;
    private final Charset charset;
    private final List<String> routes;

    private RenderConfiguration(String templatecontent, File serverbundlefile, int engines, boolean livereload, Charset charset, List<String> routes) {
        this.templatecontent = templatecontent;
        this.serverbundlefile = serverbundlefile;
        this.engines = engines;
        this.livereload = livereload;
        this.charset = charset;
        this.routes = routes;
    }

    public String getTemplateContent() {
        return this.templatecontent;
    }

    public File getServerBundleFile() {
        return this.serverbundlefile;
    }

    public int getEngines() {
        return this.engines;
    }

    public boolean getLiveReload() {
        return this.livereload;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public List<String> getRoutes() {
        return this.routes;
    }

    public static class RenderConfigurationBuilder {
        private final String templatecontent;
        private final File serverbundlefile;
        private int engines = 4;
        private boolean livereload = false;
        private Charset charset = StandardCharsets.UTF_8;
        private List<String> routes = Arrays.asList("/");

        public RenderConfigurationBuilder(String templatecontent, File serverbundlefile) {
            this.templatecontent = templatecontent;
            this.serverbundlefile = serverbundlefile;
        }

        public RenderConfigurationBuilder engines(int engines) {
            this.engines = engines;
            return this;
        }

        public RenderConfigurationBuilder liveReload(boolean livereload) {
            this.livereload = livereload;
            return this;
        }

        public RenderConfigurationBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public RenderConfigurationBuilder routes(List<String> routes) {
            this.routes = routes;
            return this;
        }

        public RenderConfiguration build() {
            return new RenderConfiguration(this.templatecontent, this.serverbundlefile, this.engines, this.livereload, this.charset, this.routes);
        }
    }
}

