/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SharedFile;
import ch.swaechter.smbjwrapper.core.AbstractSharedItem;
import ch.swaechter.smbjwrapper.utils.ShareUtils;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.smbj.auth.AuthenticationContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class SharedDirectory
extends AbstractSharedItem<SharedDirectory> {
    public SharedDirectory(String serverName, String shareName, String pathName, AuthenticationContext authenticationContext) throws IOException {
        super(serverName, shareName, pathName, authenticationContext);
    }

    public SharedDirectory(String serverName, String shareName, AuthenticationContext authenticationContext) throws IOException {
        super(serverName, shareName, "", authenticationContext);
    }

    public SharedDirectory(AbstractSharedItem abstractSharedItem, String pathName) {
        super(abstractSharedItem, pathName);
    }

    public SharedDirectory createDirectoryInCurrentDirectory(String directoryName) {
        SharedDirectory sharedDirectory = new SharedDirectory(this, this.smbPath.getPath() + "\\" + directoryName);
        sharedDirectory.createDirectory();
        return sharedDirectory;
    }

    public SharedFile createFileInCurrentDirectory(String fileName) {
        SharedFile sharedFile = new SharedFile(this, this.smbPath.getPath() + "\\" + fileName);
        sharedFile.createFile();
        return sharedFile;
    }

    public void createDirectory() {
        this.diskShare.mkdir(this.smbPath.getPath());
    }

    public void deleteDirectoryRecursively() {
        this.diskShare.rmdir(this.smbPath.getPath(), true);
    }

    public List<SharedDirectory> getDirectories() {
        ArrayList<SharedDirectory> sharedDirectories = new ArrayList<SharedDirectory>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedDirectories.add(new SharedDirectory(this, fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedDirectories;
    }

    public List<SharedFile> getFiles() {
        ArrayList<SharedFile> sharedFiles = new ArrayList<SharedFile>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> !fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedFiles.add(new SharedFile(this, fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedFiles;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof SharedDirectory) {
            SharedDirectory sharedDirectory = (SharedDirectory)object;
            return this.getSmbPath().equals(sharedDirectory.getSmbPath());
        }
        return false;
    }

    @Override
    protected SharedDirectory createSharedNodeItem(String pathName) {
        return new SharedDirectory(this, pathName);
    }

    private List<FileIdBothDirectoryInformation> getFileIdBothDirectoryInformations(Predicate<FileAllInformation> predicate) {
        String smbDirectoryPath = this.smbPath.getPath();
        ArrayList<FileIdBothDirectoryInformation> fileIdBothDirectoryInformations = new ArrayList<FileIdBothDirectoryInformation>();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.diskShare.list(smbDirectoryPath)) {
            String filePath;
            FileAllInformation fileAllInformation;
            String fileName = fileIdBothDirectoryInformation.getFileName();
            if (!ShareUtils.isValidSharedItemName(fileName) || !predicate.test(fileAllInformation = this.diskShare.getFileInformation(filePath = smbDirectoryPath.isEmpty() ? fileName : smbDirectoryPath + "\\" + fileName))) continue;
            fileIdBothDirectoryInformations.add(fileIdBothDirectoryInformation);
        }
        return fileIdBothDirectoryInformations;
    }
}

