/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper.core;

import ch.swaechter.smbjwrapper.core.SharedItem;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import java.io.IOException;

public abstract class AbstractSharedItem<T extends SharedItem>
implements SharedItem {
    protected final DiskShare diskShare;
    protected final SmbPath smbPath;

    public AbstractSharedItem(String serverName, String shareName, String pathName, AuthenticationContext authenticationContext) throws IOException {
        SMBClient smbClient = new SMBClient();
        Connection connection = smbClient.connect(serverName);
        Session session = connection.authenticate(authenticationContext);
        this.diskShare = (DiskShare)session.connectShare(shareName);
        this.smbPath = new SmbPath(serverName, shareName, pathName);
    }

    protected AbstractSharedItem(AbstractSharedItem abstractSharedItem, String pathName) {
        SmbPath otherSmbPath = abstractSharedItem.smbPath;
        this.diskShare = abstractSharedItem.diskShare;
        this.smbPath = new SmbPath(otherSmbPath.getHostname(), otherSmbPath.getShareName(), pathName);
    }

    @Override
    public boolean isExisting() {
        return this.isDirectory() || this.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.diskShare.folderExists(this.smbPath.getPath());
    }

    @Override
    public boolean isFile() {
        return this.diskShare.fileExists(this.smbPath.getPath());
    }

    @Override
    public String getName() {
        if (!this.smbPath.getPath().isEmpty()) {
            String[] parameters = this.smbPath.getPath().split("\\\\");
            return parameters[parameters.length - 1];
        }
        return "";
    }

    @Override
    public String getServerName() {
        return this.smbPath.getHostname();
    }

    @Override
    public String getShareName() {
        return this.smbPath.getShareName();
    }

    @Override
    public String getSmbPath() {
        return this.smbPath.toUncPath();
    }

    @Override
    public String getPath() {
        return this.smbPath.getPath();
    }

    public T getParentPath() {
        if (!this.getName().equals(this.smbPath.getPath())) {
            String parentPath = this.smbPath.getPath().substring(0, this.smbPath.getPath().length() - this.getName().length() - 1);
            return this.createSharedNodeItem(parentPath);
        }
        return this.getRootPath();
    }

    public T getRootPath() {
        return this.createSharedNodeItem("");
    }

    @Override
    public boolean isRootPath() {
        return this.getRootPath().equals(this.getParentPath());
    }

    public abstract boolean equals(Object var1);

    protected abstract T createSharedNodeItem(String var1);
}

