/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.SharedFile;
import ch.swaechter.smbjwrapper.core.AbstractSharedItem;
import ch.swaechter.smbjwrapper.utils.ShareUtils;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class SharedDirectory
extends AbstractSharedItem<SharedDirectory> {
    public SharedDirectory(SharedConnection sharedConnection, String pathName) throws IOException {
        super(sharedConnection, pathName);
    }

    public SharedDirectory(SharedConnection sharedConnection) throws IOException {
        super(sharedConnection, "");
    }

    public SharedDirectory createDirectoryInCurrentDirectory(String directoryName) throws IOException {
        SharedDirectory sharedDirectory = new SharedDirectory(this.sharedConnection, this.getPath() + "/" + directoryName);
        sharedDirectory.createDirectory();
        return sharedDirectory;
    }

    public SharedFile createFileInCurrentDirectory(String fileName) throws IOException {
        SharedFile sharedFile = new SharedFile(this.sharedConnection, this.getPath() + "/" + fileName);
        sharedFile.createFile();
        return sharedFile;
    }

    public void createDirectory() {
        this.sharedConnection.getDiskShare().mkdir(this.getPath());
    }

    public void deleteDirectoryRecursively() {
        this.sharedConnection.getDiskShare().rmdir(this.getPath(), true);
    }

    public List<SharedDirectory> getDirectories() throws IOException {
        ArrayList<SharedDirectory> sharedDirectories = new ArrayList<SharedDirectory>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedDirectories.add(new SharedDirectory(this.sharedConnection, this.getPath() + "/" + fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedDirectories;
    }

    public List<SharedFile> getFiles() throws IOException {
        ArrayList<SharedFile> sharedFiles = new ArrayList<SharedFile>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> !fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedFiles.add(new SharedFile(this.sharedConnection, this.getPath() + "/" + fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedFiles;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof SharedDirectory) {
            SharedDirectory sharedDirectory = (SharedDirectory)object;
            return this.getSmbPath().equals(sharedDirectory.getSmbPath());
        }
        return false;
    }

    @Override
    protected SharedDirectory createSharedNodeItem(String pathName) throws IOException {
        return new SharedDirectory(this.sharedConnection, pathName);
    }

    private List<FileIdBothDirectoryInformation> getFileIdBothDirectoryInformations(Predicate<FileAllInformation> predicate) {
        String smbDirectoryPath = this.getPath();
        ArrayList<FileIdBothDirectoryInformation> fileIdBothDirectoryInformations = new ArrayList<FileIdBothDirectoryInformation>();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.sharedConnection.getDiskShare().list(smbDirectoryPath)) {
            String filePath;
            String fileName = fileIdBothDirectoryInformation.getFileName();
            if (!ShareUtils.isValidSharedItemName(fileName)) continue;
            String string = filePath = smbDirectoryPath.isEmpty() ? fileName : smbDirectoryPath + "\\" + fileName;
            FileAllInformation fileAllInformation = this.sharedConnection.getDiskShare().getFileInformation(filePath);
            if (!predicate.test(fileAllInformation)) continue;
            fileIdBothDirectoryInformations.add(fileIdBothDirectoryInformation);
        }
        return fileIdBothDirectoryInformations;
    }
}

