/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper.core;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.core.SharedItem;
import com.hierynomus.smbj.common.SmbPath;
import java.io.IOException;

public abstract class AbstractSharedItem<T extends SharedItem>
implements SharedItem {
    protected final SharedConnection sharedConnection;
    protected final String pathName;

    public AbstractSharedItem(SharedConnection sharedConnection, String pathName) throws IOException {
        this.sharedConnection = sharedConnection;
        this.pathName = pathName;
    }

    @Override
    public boolean isExisting() {
        return this.isDirectory() || this.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.sharedConnection.getDiskShare().folderExists(this.pathName);
    }

    @Override
    public boolean isFile() {
        return this.sharedConnection.getDiskShare().fileExists(this.pathName);
    }

    @Override
    public String getName() {
        if (!this.pathName.isEmpty()) {
            int lastIndex = this.pathName.lastIndexOf("/");
            return this.pathName.substring(lastIndex + 1, this.pathName.length());
        }
        return this.pathName;
    }

    @Override
    public String getServerName() {
        return this.sharedConnection.getServerName();
    }

    @Override
    public String getShareName() {
        return this.sharedConnection.getShareName();
    }

    @Override
    public String getPath() {
        return this.pathName;
    }

    @Override
    public String getSmbPath() {
        SmbPath smbPath = new SmbPath(this.getServerName(), this.getShareName(), this.pathName.replace("/", "\\"));
        return smbPath.toUncPath();
    }

    public T getParentPath() throws IOException {
        if (!this.isRootPath()) {
            int lastIndex = this.pathName.lastIndexOf("/");
            return this.createSharedNodeItem(this.pathName.substring(0, lastIndex));
        }
        return this.getRootPath();
    }

    public T getRootPath() throws IOException {
        return this.createSharedNodeItem("");
    }

    @Override
    public boolean isRootPath() {
        int lastIndex = this.getPath().lastIndexOf("/");
        return lastIndex == 0 || lastIndex == -1;
    }

    public abstract boolean equals(Object var1);

    protected abstract T createSharedNodeItem(String var1) throws IOException;
}

