/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.share.DiskShare;
import java.io.IOException;

public class SharedConnection
implements AutoCloseable {
    private final SMBClient smbClient = new SMBClient();
    private final Connection connection;
    private final DiskShare diskShare;
    private final String serverName;
    private final String shareName;

    public SharedConnection(String serverName, String shareName, AuthenticationContext authenticationContext) throws IOException {
        this.connection = this.smbClient.connect(serverName);
        this.diskShare = (DiskShare)this.connection.authenticate(authenticationContext).connectShare(shareName);
        this.serverName = serverName;
        this.shareName = shareName;
    }

    public DiskShare getDiskShare() {
        return this.diskShare;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getShareName() {
        return this.shareName;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }
}

