/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.SharedDirectory;
import ch.swaechter.smbjwrapper.core.AbstractSharedItem;
import ch.swaechter.smbjwrapper.streams.SharedInputStream;
import ch.swaechter.smbjwrapper.streams.SharedOutputStream;
import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.fileinformation.FileStandardInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.share.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;

public final class SharedFile
extends AbstractSharedItem<SharedDirectory> {
    public SharedFile(SharedConnection sharedConnection, String pathName) {
        super(sharedConnection, pathName);
    }

    public void createFile() {
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null);
        file.close();
    }

    public void deleteFile() {
        this.getDiskShare().rm(this.getPath());
    }

    public InputStream getInputStream() {
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_READ), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN_IF, null);
        return new SharedInputStream(file);
    }

    public OutputStream getOutputStream() {
        File file = this.getDiskShare().openFile(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, null);
        return new SharedOutputStream(file);
    }

    public long getFileSize() {
        FileStandardInformation fileStandardInformation = this.getDiskShare().getFileInformation(this.getPath()).getStandardInformation();
        return fileStandardInformation.getEndOfFile();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof SharedFile) {
            SharedFile sharedFile = (SharedFile)object;
            return this.getSmbPath().equals(sharedFile.getSmbPath());
        }
        return false;
    }

    @Override
    protected SharedDirectory createSharedNodeItem(String pathName) {
        return new SharedDirectory(this.getSharedConnection(), pathName);
    }
}

