/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.SharedFile;
import ch.swaechter.smbjwrapper.core.AbstractSharedItem;
import ch.swaechter.smbjwrapper.utils.ShareUtils;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class SharedDirectory
extends AbstractSharedItem<SharedDirectory> {
    public SharedDirectory(SharedConnection sharedConnection, String pathName) {
        super(sharedConnection, pathName);
    }

    public SharedDirectory(SharedConnection sharedConnection) {
        super(sharedConnection, "");
    }

    public SharedDirectory createDirectoryInCurrentDirectory(String directoryName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SharedDirectory sharedDirectory = new SharedDirectory(this.getSharedConnection(), pathSuffix + directoryName);
        sharedDirectory.createDirectory();
        return sharedDirectory;
    }

    public SharedFile createFileInCurrentDirectory(String fileName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SharedFile sharedFile = new SharedFile(this.getSharedConnection(), pathSuffix + fileName);
        sharedFile.createFile();
        return sharedFile;
    }

    public void createDirectory() {
        this.getDiskShare().mkdir(this.getPath());
    }

    public void deleteDirectoryRecursively() {
        this.getDiskShare().rmdir(this.getPath(), true);
    }

    public List<SharedDirectory> getDirectories() {
        ArrayList<SharedDirectory> sharedDirectories = new ArrayList<SharedDirectory>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedDirectories.add(new SharedDirectory(this.getSharedConnection(), this.getPath() + "/" + fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedDirectories;
    }

    public List<SharedFile> getFiles() {
        ArrayList<SharedFile> sharedFiles = new ArrayList<SharedFile>();
        Predicate<FileAllInformation> predicate = fileAllInformation -> !fileAllInformation.getStandardInformation().isDirectory();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getFileIdBothDirectoryInformations(predicate)) {
            sharedFiles.add(new SharedFile(this.getSharedConnection(), this.getPath() + "/" + fileIdBothDirectoryInformation.getFileName()));
        }
        return sharedFiles;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SharedDirectory) {
            SharedDirectory sharedDirectory = (SharedDirectory)object;
            return this.getSmbPath().equals(sharedDirectory.getSmbPath());
        }
        return false;
    }

    @Override
    protected SharedDirectory createSharedNodeItem(String pathName) {
        return new SharedDirectory(this.getSharedConnection(), pathName);
    }

    private List<FileIdBothDirectoryInformation> getFileIdBothDirectoryInformations(Predicate<FileAllInformation> predicate) {
        String smbDirectoryPath = this.getPath();
        ArrayList<FileIdBothDirectoryInformation> fileIdBothDirectoryInformations = new ArrayList<FileIdBothDirectoryInformation>();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getDiskShare().list(smbDirectoryPath)) {
            String filePath;
            String fileName = fileIdBothDirectoryInformation.getFileName();
            if (!ShareUtils.isValidSharedItemName(fileName)) continue;
            String string = filePath = smbDirectoryPath.isEmpty() ? fileName : smbDirectoryPath + "/" + fileName;
            FileAllInformation fileAllInformation = this.getDiskShare().getFileInformation(filePath);
            if (!predicate.test(fileAllInformation)) continue;
            fileIdBothDirectoryInformations.add(fileIdBothDirectoryInformation);
        }
        return fileIdBothDirectoryInformations;
    }
}

