/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.SharedFile;
import ch.swaechter.smbjwrapper.core.AbstractSharedItem;
import ch.swaechter.smbjwrapper.core.SharedItem;
import ch.swaechter.smbjwrapper.utils.ShareUtils;
import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.share.Directory;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SharedDirectory
extends AbstractSharedItem<SharedDirectory> {
    public SharedDirectory(SharedConnection sharedConnection, String pathName) {
        super(sharedConnection, pathName);
    }

    public SharedDirectory(SharedConnection sharedConnection) {
        super(sharedConnection, "");
    }

    public void ensureExists() {
        if (!this.isExisting()) {
            this.createDirectory();
        } else if (!this.isDirectory()) {
            throw new IllegalStateException("The given path does already exist, but not as directory");
        }
    }

    public SharedDirectory createDirectoryInCurrentDirectory(String directoryName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SharedDirectory sharedDirectory = new SharedDirectory(this.getSharedConnection(), pathSuffix + directoryName);
        sharedDirectory.createDirectory();
        return sharedDirectory;
    }

    public SharedFile createFileInCurrentDirectory(String fileName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SharedFile sharedFile = new SharedFile(this.getSharedConnection(), pathSuffix + fileName);
        sharedFile.createFile();
        return sharedFile;
    }

    public void createDirectory() {
        this.getDiskShare().mkdir(this.getPath());
    }

    public void deleteDirectoryRecursively() {
        this.getDiskShare().rmdir(this.getPath(), true);
    }

    public List<SharedDirectory> getDirectories() {
        List<SharedItem> sharedItems = this.sortItems(this.listItems(SharedItem::isDirectory, false));
        return sharedItems.stream().map(item -> (SharedDirectory)item).collect(Collectors.toList());
    }

    public List<SharedFile> getFiles() {
        List<SharedItem> sharedItems = this.sortItems(this.listItems(SharedItem::isFile, false));
        return sharedItems.stream().map(item -> (SharedFile)item).collect(Collectors.toList());
    }

    public List<SharedItem> listFiles(Predicate<SharedItem> searchPredicate, boolean searchRecursive) {
        return this.sortItems(this.listItems(searchPredicate, searchRecursive));
    }

    public List<SharedItem> listFiles(String searchPattern, boolean searchRecursive) {
        Pattern pattern = Pattern.compile(searchPattern);
        return this.sortItems(this.listItems(sharedItem -> pattern.matcher(sharedItem.getName()).matches(), searchRecursive));
    }

    @Override
    public void renameTo(String newFileName, boolean replaceIfExist) {
        try (Directory directory = this.getDiskShare().openDirectory(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            String newFilePath = ((SharedDirectory)this.getParentPath()).getPath() + "/" + newFileName;
            directory.rename(newFilePath, replaceIfExist);
            this.setPathName(newFilePath);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SharedDirectory) {
            SharedDirectory sharedDirectory = (SharedDirectory)object;
            return this.getSmbPath().equals(sharedDirectory.getSmbPath());
        }
        return false;
    }

    @Override
    protected SharedDirectory createSharedNodeItem(String pathName) {
        return new SharedDirectory(this.getSharedConnection(), pathName);
    }

    private List<SharedItem> listItems(Predicate<SharedItem> searchPredicate, boolean searchRecursive) {
        String smbDirectoryPath = this.getPath();
        LinkedList<SharedItem> sharedItems = new LinkedList<SharedItem>();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getDiskShare().list(smbDirectoryPath)) {
            String filePath;
            String fileName = fileIdBothDirectoryInformation.getFileName();
            String string = filePath = smbDirectoryPath.isEmpty() ? fileName : smbDirectoryPath + "/" + fileName;
            if (!ShareUtils.isValidSharedItemName(fileName)) continue;
            FileAllInformation fileAllInformation = this.getDiskShare().getFileInformation(filePath);
            if (fileAllInformation.getStandardInformation().isDirectory()) {
                SharedDirectory sharedDirectory = new SharedDirectory(this.getSharedConnection(), filePath);
                this.filterItem(sharedItems, sharedDirectory, searchPredicate);
                if (!searchRecursive) continue;
                sharedItems.addAll(sharedDirectory.listFiles(searchPredicate, true));
                continue;
            }
            SharedFile sharedFile = new SharedFile(this.getSharedConnection(), filePath);
            this.filterItem(sharedItems, sharedFile, searchPredicate);
        }
        return sharedItems;
    }

    private void filterItem(List<SharedItem> sharedItems, SharedItem sharedItem, Predicate<SharedItem> searchPredicate) {
        if (searchPredicate.test(sharedItem)) {
            sharedItems.add(sharedItem);
        }
    }

    private List<SharedItem> sortItems(List<SharedItem> sharedItems) {
        sharedItems.sort(Comparator.comparing(SharedItem::getPath));
        return sharedItems;
    }
}

