/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper.core;

import ch.swaechter.smbjwrapper.SharedConnection;
import ch.swaechter.smbjwrapper.core.SharedItem;
import ch.swaechter.smbjwrapper.utils.ShareUtils;
import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.msfscc.fileinformation.FileBasicInformation;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.share.DiskShare;

public abstract class AbstractSharedItem<T extends SharedItem>
implements SharedItem {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ROOT_PATH = "";
    private final SharedConnection sharedConnection;
    private String pathName;

    public AbstractSharedItem(SharedConnection sharedConnection, String pathName) {
        this.sharedConnection = sharedConnection;
        this.setPathName(pathName);
    }

    @Override
    public boolean isExisting() {
        return this.isDirectory() || this.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.sharedConnection.getDiskShare().folderExists(this.pathName);
    }

    @Override
    public boolean isFile() {
        return this.sharedConnection.getDiskShare().fileExists(this.pathName);
    }

    @Override
    public String getName() {
        if (!this.pathName.isEmpty()) {
            int lastIndex = this.pathName.lastIndexOf(PATH_SEPARATOR);
            return this.pathName.substring(lastIndex + 1, this.pathName.length());
        }
        return this.pathName;
    }

    @Override
    public String getServerName() {
        return this.sharedConnection.getServerName();
    }

    @Override
    public String getShareName() {
        return this.sharedConnection.getShareName();
    }

    @Override
    public String getPath() {
        return this.pathName;
    }

    @Override
    public String getSmbPath() {
        SmbPath smbPath = new SmbPath(this.getServerName(), this.getShareName(), this.pathName.replace(PATH_SEPARATOR, "\\"));
        return smbPath.toUncPath();
    }

    public T getParentPath() {
        if (!this.isRootPath()) {
            int lastIndex = this.pathName.lastIndexOf(PATH_SEPARATOR);
            return this.createSharedNodeItem(this.pathName.substring(0, lastIndex));
        }
        return this.getRootPath();
    }

    public T getRootPath() {
        return this.createSharedNodeItem(ROOT_PATH);
    }

    @Override
    public boolean isRootPath() {
        int lastIndex = this.getPath().lastIndexOf(PATH_SEPARATOR);
        return lastIndex == 0 || lastIndex == -1;
    }

    @Override
    public FileTime getCreationTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getCreationTime();
    }

    @Override
    public FileTime getLastAccessTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getLastAccessTime();
    }

    @Override
    public FileTime getLastWriteTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getLastWriteTime();
    }

    @Override
    public FileTime getChangeTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getChangeTime();
    }

    protected void setPathName(String pathName) {
        if (!ShareUtils.isValidSharedItemName(pathName)) {
            throw new RuntimeException("The given path name is not a valid share path");
        }
        this.pathName = pathName;
    }

    public abstract boolean equals(Object var1);

    protected SharedConnection getSharedConnection() {
        return this.sharedConnection;
    }

    protected DiskShare getDiskShare() {
        return this.getSharedConnection().getDiskShare();
    }

    protected abstract T createSharedNodeItem(String var1);
}

