/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SmbConnection;
import ch.swaechter.smbjwrapper.SmbFile;
import ch.swaechter.smbjwrapper.SmbItem;
import ch.swaechter.smbjwrapper.utils.SmbUtils;
import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.share.Directory;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SmbDirectory
extends SmbItem {
    public SmbDirectory(SmbConnection smbConnection, String pathName) {
        super(smbConnection, pathName);
    }

    public SmbDirectory(SmbConnection smbConnection) {
        super(smbConnection, "");
    }

    public void ensureExists() {
        if (!this.isExisting()) {
            this.createDirectory();
        } else if (!this.isDirectory()) {
            throw new IllegalStateException("The given path does already exist, but not as directory");
        }
    }

    public SmbDirectory createDirectoryInCurrentDirectory(String directoryName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SmbDirectory smbDirectory = new SmbDirectory(this.getSmbConnection(), pathSuffix + directoryName);
        smbDirectory.createDirectory();
        return smbDirectory;
    }

    public SmbFile createFileInCurrentDirectory(String fileName) {
        String pathSuffix = !this.getPath().isEmpty() ? this.getPath() + "/" : "";
        SmbFile smbFile = new SmbFile(this.getSmbConnection(), pathSuffix + fileName);
        smbFile.createFile();
        return smbFile;
    }

    public void createDirectory() {
        this.getDiskShare().mkdir(this.getPath());
    }

    public void deleteDirectoryRecursively() {
        this.getDiskShare().rmdir(this.getPath(), true);
    }

    public List<SmbDirectory> getDirectories() {
        List<SmbItem> smbItems = this.sortItems(this.listItems(SmbItem::isDirectory, false));
        return smbItems.stream().map(item -> (SmbDirectory)item).collect(Collectors.toList());
    }

    public List<SmbFile> getFiles() {
        List<SmbItem> smbItems = this.sortItems(this.listItems(SmbItem::isFile, false));
        return smbItems.stream().map(item -> (SmbFile)item).collect(Collectors.toList());
    }

    public List<SmbItem> listFiles() {
        return this.sortItems(this.listItems(smbItem -> true, false));
    }

    public List<SmbItem> listFiles(Predicate<SmbItem> searchPredicate, boolean searchRecursive) {
        return this.sortItems(this.listItems(searchPredicate, searchRecursive));
    }

    public List<SmbItem> listFiles(String searchPattern, boolean searchRecursive) {
        Pattern pattern = Pattern.compile(searchPattern);
        return this.sortItems(this.listItems(smbItem -> pattern.matcher(smbItem.getName()).matches(), searchRecursive));
    }

    @Override
    public SmbDirectory renameTo(String newDirectoryName, boolean replaceIfExist) {
        try (Directory directory = this.getDiskShare().openDirectory(this.getPath(), EnumSet.of(AccessMask.GENERIC_ALL), null, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN, null);){
            String newDirectoryPath = this.getParentPath().getPath() + "/" + newDirectoryName;
            directory.rename(newDirectoryPath, replaceIfExist);
            SmbDirectory smbDirectory = new SmbDirectory(this.getSmbConnection(), newDirectoryPath);
            return smbDirectory;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SmbDirectory) {
            SmbDirectory smbDirectory = (SmbDirectory)object;
            return this.getSmbPath().equals(smbDirectory.getSmbPath());
        }
        return false;
    }

    private List<SmbItem> listItems(Predicate<SmbItem> searchPredicate, boolean searchRecursive) {
        String smbDirectoryPath = this.getPath();
        LinkedList<SmbItem> smbItems = new LinkedList<SmbItem>();
        for (FileIdBothDirectoryInformation fileIdBothDirectoryInformation : this.getDiskShare().list(smbDirectoryPath)) {
            String filePath;
            String fileName = fileIdBothDirectoryInformation.getFileName();
            String string = filePath = smbDirectoryPath.isEmpty() ? fileName : smbDirectoryPath + "/" + fileName;
            if (!SmbUtils.isValidSmbItemName(fileName)) continue;
            FileAllInformation fileAllInformation = this.getDiskShare().getFileInformation(filePath);
            if (fileAllInformation.getStandardInformation().isDirectory()) {
                SmbDirectory smbDirectory = new SmbDirectory(this.getSmbConnection(), filePath);
                this.filterItem(smbItems, smbDirectory, searchPredicate);
                if (!searchRecursive) continue;
                smbItems.addAll(smbDirectory.listFiles(searchPredicate, true));
                continue;
            }
            SmbFile smbFile = new SmbFile(this.getSmbConnection(), filePath);
            this.filterItem(smbItems, smbFile, searchPredicate);
        }
        return smbItems;
    }

    private void filterItem(List<SmbItem> smbItems, SmbItem smbItem, Predicate<SmbItem> searchPredicate) {
        if (searchPredicate.test(smbItem)) {
            smbItems.add(smbItem);
        }
    }

    private List<SmbItem> sortItems(List<SmbItem> smbItems) {
        smbItems.sort(Comparator.comparing(SmbItem::getPath));
        return smbItems;
    }
}

