/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.share.DiskShare;
import java.io.IOException;

public class SmbConnection
implements AutoCloseable {
    private final AuthenticationContext authenticationContext;
    private final SmbConfig smbConfig;
    private final String serverName;
    private final String shareName;
    private Connection connection;
    private DiskShare diskShare;

    public SmbConnection(String serverName, String shareName, AuthenticationContext authenticationContext) throws IOException {
        this(serverName, shareName, authenticationContext, SmbConfig.builder().build(), false);
    }

    public SmbConnection(String serverName, String shareName, AuthenticationContext authenticationContext, SmbConfig smbConfig) throws IOException {
        this(serverName, shareName, authenticationContext, smbConfig, false);
    }

    public SmbConnection(String serverName, String shareName, AuthenticationContext authenticationContext, SmbConfig smbConfig, boolean delayedInitialization) throws IOException {
        this.authenticationContext = authenticationContext;
        this.smbConfig = smbConfig;
        this.serverName = serverName;
        this.shareName = shareName;
        if (!delayedInitialization) {
            this.connectToServer();
        }
    }

    public DiskShare getDiskShare() {
        if (!this.isConnectionAlive()) {
            try {
                this.ensureConnectionIsAlive();
            }
            catch (IOException exception) {
                throw new RuntimeException("Unable to initialize the delayed connection: " + exception.getMessage(), exception);
            }
        }
        return this.diskShare;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getShareName() {
        return this.shareName;
    }

    public boolean isConnectionAlive() {
        if (this.connection == null || this.diskShare == null) {
            return false;
        }
        return this.connection.isConnected() && this.diskShare.isConnected();
    }

    public void ensureConnectionIsAlive() throws IOException {
        if (!this.isConnectionAlive()) {
            this.close();
            this.connectToServer();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null && this.connection.isConnected()) {
            this.connection.close(true);
        }
    }

    private void connectToServer() throws IOException {
        SMBClient smbClient = new SMBClient(this.smbConfig);
        this.connection = smbClient.connect(this.serverName);
        this.diskShare = (DiskShare)this.connection.authenticate(this.authenticationContext).connectShare(this.shareName);
    }
}

