/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper;

import ch.swaechter.smbjwrapper.SmbConnection;
import ch.swaechter.smbjwrapper.SmbDirectory;
import ch.swaechter.smbjwrapper.utils.SmbUtils;
import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileBasicInformation;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.share.DiskShare;

public abstract class SmbItem {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ROOT_PATH = "";
    private final SmbConnection smbConnection;
    private final String pathName;

    public SmbItem(SmbConnection smbConnection, String pathName) {
        this.smbConnection = smbConnection;
        if (!SmbUtils.isValidSmbItemName(pathName)) {
            throw new RuntimeException("The given path name is not a valid SMB path");
        }
        this.pathName = pathName;
    }

    public boolean isExisting() {
        return this.isDirectory() || this.isFile();
    }

    public boolean isDirectory() {
        return this.smbConnection.getDiskShare().folderExists(this.pathName);
    }

    public boolean isFile() {
        return this.smbConnection.getDiskShare().fileExists(this.pathName);
    }

    public boolean isHidden() {
        long attributeMask = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation().getFileAttributes();
        return EnumWithValue.EnumUtils.isSet((long)attributeMask, (EnumWithValue)FileAttributes.FILE_ATTRIBUTE_HIDDEN);
    }

    public String getServerName() {
        return this.smbConnection.getServerName();
    }

    public String getShareName() {
        return this.smbConnection.getShareName();
    }

    public String getName() {
        if (!this.pathName.isEmpty()) {
            int lastIndex = this.pathName.lastIndexOf(PATH_SEPARATOR);
            return this.pathName.substring(lastIndex + 1);
        }
        return this.pathName;
    }

    public String getPath() {
        return this.pathName;
    }

    public String getSmbPath() {
        SmbPath smbPath = new SmbPath(this.getServerName(), this.getShareName(), this.pathName.replace(PATH_SEPARATOR, "\\"));
        return smbPath.toUncPath();
    }

    public SmbDirectory getParentPath() {
        if (!this.isRootPath()) {
            int lastIndex = this.pathName.lastIndexOf(PATH_SEPARATOR);
            return new SmbDirectory(this.getSmbConnection(), this.pathName.substring(0, lastIndex));
        }
        return this.getRootPath();
    }

    public SmbDirectory getRootPath() {
        return new SmbDirectory(this.smbConnection, ROOT_PATH);
    }

    public boolean isRootPath() {
        int lastIndex = this.getPath().lastIndexOf(PATH_SEPARATOR);
        return lastIndex == 0 || lastIndex == -1;
    }

    public FileTime getCreationTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getCreationTime();
    }

    public FileTime getLastAccessTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getLastAccessTime();
    }

    public FileTime getLastWriteTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getLastWriteTime();
    }

    public FileTime getChangeTime() {
        FileBasicInformation fileBasicInformation = this.getDiskShare().getFileInformation(this.pathName).getBasicInformation();
        return fileBasicInformation.getChangeTime();
    }

    protected static String buildProperItemPath(String path, String name) {
        if (!path.isEmpty()) {
            return path + PATH_SEPARATOR + name;
        }
        return name;
    }

    protected static boolean isValidSmbItemName(String itemName) {
        switch (itemName) {
            case ".": 
            case "..": 
            case "/": {
                return false;
            }
        }
        return true;
    }

    public abstract boolean equals(Object var1);

    protected SmbConnection getSmbConnection() {
        return this.smbConnection;
    }

    protected DiskShare getDiskShare() {
        return this.getSmbConnection().getDiskShare();
    }

    public abstract SmbItem renameTo(String var1, boolean var2);
}

