/*
 * Decompiled with CFR 0.152.
 */
package ch.swaechter.smbjwrapper.streams;

import com.hierynomus.smbj.share.File;
import java.io.IOException;
import java.io.OutputStream;

public class SmbOutputStream
extends OutputStream {
    private final File file;
    private final OutputStream outputStream;
    private final Boolean appendContent;

    public SmbOutputStream(File file, boolean appendContent) {
        this.file = file;
        this.outputStream = file.getOutputStream(appendContent);
        this.appendContent = appendContent;
    }

    @Override
    public void write(int value) throws IOException {
        this.outputStream.write(value);
    }

    @Override
    public void write(byte[] values) throws IOException {
        this.outputStream.write(values, 0, values.length);
    }

    @Override
    public void write(byte[] values, int offset, int length) throws IOException {
        if (this.appendContent.booleanValue()) {
            throw new IOException("The method SmbOutputStream.write(values, offset, length) can not be used when appendingContent is set to true.");
        }
        this.outputStream.write(values, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
        this.file.close();
    }
}

