/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app;

import ch.tatool.app.GuiController;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.data.UserAccount;
import ch.tatool.module.ModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class App
implements ApplicationListener {
    private Logger logger = LoggerFactory.getLogger(App.class);
    private GuiController guiController;
    private UserAccountService userAccountService;
    private ModuleService moduleService;

    public App() {
        this.logger.info("App bean loaded - waiting until context completely initialized...");
    }

    private void startApplication() {
        UserAccount account = null;
        this.guiController.setEnabled(true);
        this.guiController.setUserAccount(account);
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.logger.info("Context initialized - starting the application...");
            this.startApplication();
        }
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    public void setGuiController(GuiController guiController) {
        this.guiController = guiController;
    }

    public UserAccountService getUserAccountService() {
        return this.userAccountService;
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public ModuleService getModuleService() {
        return this.moduleService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public static void main(String[] args) {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("/tatool/application-context.xml");
    }
}

