/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.data.Messages;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessagesImpl
implements Messages {
    private static final String BUNDLE_NAME = "ch.tatool.messages";
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("ch.tatool.messages", Locale.getDefault());
    private Locale currentLocale;

    private MessagesImpl() {
    }

    public void setLocale(Locale local) {
        this.currentLocale = local;
        this.resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, local);
    }

    public String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public String getLanguage() {
        return this.currentLocale.getLanguage();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

