/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.UserAccountImpl;
import java.io.Serializable;
import java.util.Random;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class UserAccountDAO
extends HibernateDaoSupport {
    public void loadAccount(UserAccountImpl userAccount) {
        if (userAccount.getId() != null) {
            this.getHibernateTemplate().load((Object)userAccount, (Serializable)userAccount.getId());
        } else {
            Long id = new Random().nextLong();
            id = Math.abs(id);
            userAccount.setId(id);
            this.getHibernateTemplate().save((Object)userAccount);
            this.setScriptType(userAccount);
        }
    }

    public void saveAccount(UserAccountImpl account) {
        this.getHibernateTemplate().saveOrUpdate((Object)account);
    }

    public void deleteAccount(UserAccountImpl account) {
        this.getHibernateTemplate().delete((Object)account);
    }

    public void setAccountPassword(final UserAccountImpl account, final String password) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                BasicDataSource dataSource = (BasicDataSource)account.getBeanFactory().getBean("userAccountDataSource");
                String username = dataSource.getUsername();
                String newPassword = password != null ? password : "";
                try {
                    StringBuilder sql = new StringBuilder();
                    sql.append("ALTER USER '").append(username).append("' SET PASSWORD '").append(newPassword).append("'");
                    SQLQuery query = session.createSQLQuery(sql.toString());
                    query.executeUpdate();
                    dataSource.setPassword(newPassword);
                    account.setPassword(newPassword);
                    account.setPasswordProtected(!newPassword.isEmpty());
                }
                catch (HibernateException hb) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private void setScriptType(UserAccountImpl account) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                try {
                    String sql = "SET FILES SCRIPT FORMAT TEXT";
                    SQLQuery query = session.createSQLQuery(sql);
                    query.executeUpdate();
                }
                catch (HibernateException hibernateException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void shutdown() {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                try {
                    String sql = "SHUTDOWN";
                    SQLQuery query = session.createSQLQuery(sql);
                    query.executeUpdate();
                }
                catch (HibernateException hibernateException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

