/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.setup;

import ch.tatool.module.ModuleCreator;
import ch.tatool.module.ModuleCreatorRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModuleCreatorRegistry
implements ModuleCreatorRegistry {
    Logger logger = LoggerFactory.getLogger(DefaultModuleCreatorRegistry.class);
    private Map<String, ModuleCreator> creatorsMap = new TreeMap<String, ModuleCreator>();

    public List<ModuleCreator> getCreators() {
        return new ArrayList<ModuleCreator>(this.creatorsMap.values());
    }

    public ModuleCreator getCreatorById(String id) {
        return this.creatorsMap.get(id);
    }

    public void addCreators(List<ModuleCreator> creators) {
        for (ModuleCreator c : creators) {
            this.addCreator(c);
        }
    }

    public void addCreator(ModuleCreator creator) {
        this.creatorsMap.put(creator.getCreatorId(), creator);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Registered creator \"" + creator.getCreatorId() + "\".");
        }
    }

    public void removeAll() {
        this.creatorsMap.clear();
    }
}

