/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app;

import ch.tatool.app.gui.LoginFrame;
import ch.tatool.app.gui.ModuleManagerFrame;
import ch.tatool.app.gui.ModuleOverviewFrame;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.app.service.exec.ExecutionService;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import ch.tatool.module.ModuleService;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiController {
    private Logger logger = LoggerFactory.getLogger(GuiController.class);
    public static final String LOGIN_FRAME = "LoginFrame";
    public static final String MODULE_MANAGER_FRAME = "ModuleManagerFrame";
    public static final String MODULE_OPEN_FRAME = "ModuleOpenFrame";
    public static final String MODULE_OVERVIEW_FRAME = "ModuleOverviewFrame";
    private UserAccount userAccount;
    private Module module;
    private UserAccountService userAccountService;
    private ModuleService moduleService;
    private ExecutionService executionService;
    private LoginFrame loginFrame;
    private ModuleManagerFrame moduleManagerFrame;
    private ModuleOverviewFrame moduleOverviewFrame;
    private FrameVisibilityListener frameVisibilityListener;
    private ModuleExecutorWindowDisplayer moduleExecutionListener;
    private boolean enabled = false;
    private Map<String, Boolean> displayedWindows = new HashMap<String, Boolean>();
    private Map<String, Boolean> enabledWindows = new HashMap<String, Boolean>();

    public GuiController() {
        this.enabledWindows.put(LOGIN_FRAME, true);
        this.enabledWindows.put(MODULE_MANAGER_FRAME, true);
        this.enabledWindows.put(MODULE_OVERVIEW_FRAME, true);
        this.enabledWindows.put(MODULE_OPEN_FRAME, true);
        this.displayedWindows.put(LOGIN_FRAME, false);
        this.displayedWindows.put(MODULE_MANAGER_FRAME, false);
        this.displayedWindows.put(MODULE_OVERVIEW_FRAME, false);
        this.displayedWindows.put(MODULE_OPEN_FRAME, false);
        this.frameVisibilityListener = new FrameVisibilityListener();
        this.moduleExecutionListener = new ModuleExecutorWindowDisplayer();
    }

    public void init() {
        this.loginFrame.addComponentListener(this.frameVisibilityListener);
        this.moduleManagerFrame.addComponentListener(this.frameVisibilityListener);
        this.moduleOverviewFrame.addComponentListener(this.frameVisibilityListener);
        this.executionService.getPhaseListenerManager().addExecutionPhaseListener((ExecutionPhaseListener)this.moduleExecutionListener, ExecutionPhase.EXECUTION_START);
        this.executionService.getPhaseListenerManager().addExecutionPhaseListener((ExecutionPhaseListener)this.moduleExecutionListener, ExecutionPhase.EXECUTION_FINISH);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void startGUI() {
        this.displayMostSuitableWindow();
    }

    private void displayMostSuitableWindow() {
        if (this.userAccount != null && this.module != null) {
            this.displayModuleOverviewFrame();
        } else if (this.userAccount != null) {
            this.displayModuleManagerFrame();
        } else {
            this.displayLoginFrame();
        }
    }

    private void hideModuleManagerFrame() {
        if (this.displayedWindows.get(MODULE_MANAGER_FRAME).booleanValue()) {
            this.displayedWindows.put(MODULE_MANAGER_FRAME, false);
            this.moduleManagerFrame.setVisible(false);
        }
    }

    private void hideModuleOverviewFrame() {
        if (this.displayedWindows.get(MODULE_OVERVIEW_FRAME).booleanValue()) {
            this.displayedWindows.put(MODULE_OVERVIEW_FRAME, false);
            this.moduleOverviewFrame.setVisible(false);
        }
    }

    private void hideLoginFrame() {
        if (this.displayedWindows.get(LOGIN_FRAME).booleanValue()) {
            this.displayedWindows.put(LOGIN_FRAME, false);
            this.loginFrame.setVisible(false);
        }
    }

    public void displayModuleOverviewFrame() {
        if (this.userAccount == null || this.module == null) {
            throw new RuntimeException("Cannot display module overview without account and module");
        }
        this.hideModuleManagerFrame();
        this.hideLoginFrame();
        this.moduleOverviewFrame.initialize(this.module);
        this.moduleOverviewFrame.setVisible(true);
        this.moduleOverviewFrame.toFront();
        this.displayedWindows.put(MODULE_OVERVIEW_FRAME, true);
    }

    public void displayModuleManagerFrame() {
        if (this.userAccount == null) {
            throw new RuntimeException("Cannot display module manager without account");
        }
        this.hideLoginFrame();
        if (this.displayedWindows.get(MODULE_OVERVIEW_FRAME).booleanValue()) {
            // empty if block
        }
        this.moduleManagerFrame.initialize(this.userAccount);
        this.moduleManagerFrame.setVisible(true);
        this.moduleManagerFrame.toFront();
        this.displayedWindows.put(MODULE_MANAGER_FRAME, true);
    }

    public void displayLoginFrame() {
        this.loginFrame.initialize();
        this.loginFrame.setVisible(true);
        this.loginFrame.toFront();
        this.displayedWindows.put(LOGIN_FRAME, true);
    }

    private void closeCurrentModule() {
        if (this.module != null) {
            this.hideModuleOverviewFrame();
            this.moduleService.closeModule(this.module);
            this.module = null;
        }
    }

    private void closeCurrentAccount() {
        if (this.userAccount != null) {
            this.userAccountService.closeAccount(this.userAccount);
            this.userAccount = null;
        }
    }

    public void setModule(Module module) {
        this.closeCurrentModule();
        this.module = module;
        if (this.enabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiController.this.displayMostSuitableWindow();
                }
            });
        }
    }

    public void setUserAccount(final UserAccount userAccount) {
        this.closeCurrentModule();
        this.closeCurrentAccount();
        this.userAccount = userAccount;
        if (this.enabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (userAccount != null) {
                        GuiController.this.checkAccountPreferences();
                    }
                    GuiController.this.displayMostSuitableWindow();
                }
            });
        }
    }

    private void checkAccountPreferences() {
        this.checkLoadLastOpenedAccount();
        this.checkDisableModuleManager();
    }

    private void checkLoadLastOpenedAccount() {
        if (!this.userAccount.getProperties().containsKey("OpenLastLoadedModuleOnStartup") || !Boolean.parseBoolean((String)this.userAccount.getProperties().get("OpenLastLoadedModuleOnStartup"))) {
            return;
        }
        String defaultModuleId = (String)this.userAccount.getProperties().get("LastLoadedModule");
        if (defaultModuleId == null) {
            return;
        }
        Module.Info tInfo = null;
        for (Module.Info i : this.moduleService.getModules(this.userAccount)) {
            if (!i.getId().toString().equals(defaultModuleId)) continue;
            tInfo = i;
            break;
        }
        if (tInfo != null) {
            Module module;
            this.module = module = this.moduleService.loadModule(tInfo);
        }
    }

    private void checkDisableModuleManager() {
        Module module;
        boolean moduleManagerDisabled;
        String value = (String)this.userAccount.getProperties().get("tatool.disable.module.management");
        boolean bl = moduleManagerDisabled = value != null && Boolean.parseBoolean(value);
        if (!moduleManagerDisabled) {
            this.moduleOverviewFrame.setModuleManagementEnabled(true);
            return;
        }
        this.moduleOverviewFrame.setModuleManagementEnabled(false);
        if (this.module != null) {
            return;
        }
        Set infos = this.moduleService.getModules(this.userAccount);
        if (infos.size() < 1) {
            throw new RuntimeException("Invalid user account - module management disabled but no modules available!");
        }
        Module.Info tInfo = (Module.Info)infos.iterator().next();
        this.module = module = this.moduleService.loadModule(tInfo);
    }

    void loginClosed() {
        if (this.displayedWindows.get(LOGIN_FRAME).booleanValue()) {
            this.displayedWindows.put(LOGIN_FRAME, false);
            this.checkProgramExit();
        }
    }

    void moduleManagerClosed() {
        if (this.displayedWindows.get(MODULE_MANAGER_FRAME).booleanValue()) {
            this.displayedWindows.put(MODULE_MANAGER_FRAME, false);
            this.checkProgramExit();
        }
    }

    void openDetailClosed() {
        if (this.displayedWindows.get(MODULE_OPEN_FRAME).booleanValue()) {
            this.displayedWindows.put(MODULE_OPEN_FRAME, false);
            this.checkProgramExit();
        }
    }

    void moduleOverviewClosed() {
        if (this.displayedWindows.get(MODULE_OVERVIEW_FRAME).booleanValue()) {
            this.displayedWindows.put(MODULE_OVERVIEW_FRAME, false);
            this.checkProgramExit();
        }
    }

    void checkProgramExit() {
        boolean open = false;
        for (Boolean b : this.displayedWindows.values()) {
            open = open || b != false;
        }
        if (!open) {
            this.shutdown();
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down...");
        this.closeCurrentModule();
        this.closeCurrentAccount();
        System.exit(0);
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public Module getModule() {
        return this.module;
    }

    public LoginFrame getLoginFrame() {
        return this.loginFrame;
    }

    public void setLoginFrame(LoginFrame loginFrame) {
        this.loginFrame = loginFrame;
    }

    public ModuleOverviewFrame getModuleOverviewFrame() {
        return this.moduleOverviewFrame;
    }

    public void setModuleOverviewFrame(ModuleOverviewFrame moduleOverviewFrame) {
        this.moduleOverviewFrame = moduleOverviewFrame;
    }

    public UserAccountService getUserAccountService() {
        return this.userAccountService;
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public ModuleService getModuleService() {
        return this.moduleService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public ExecutionService getExecutionService() {
        return this.executionService;
    }

    public void setExecutionService(ExecutionService executionService) {
        this.executionService = executionService;
    }

    public ModuleManagerFrame getModuleManagerFrame() {
        return this.moduleManagerFrame;
    }

    public void setModuleManagerFrame(ModuleManagerFrame moduleManagerFrame) {
        this.moduleManagerFrame = moduleManagerFrame;
    }

    class ModuleExecutorWindowDisplayer
    implements ExecutionPhaseListener {
        ModuleExecutorWindowDisplayer() {
        }

        public void processExecutionPhase(ExecutionContext event) {
            switch (event.getPhase()) {
                case EXECUTION_FINISH: {
                    this.moduleFinished();
                }
            }
        }

        private void moduleFinished() {
            GuiController.this.checkProgramExit();
        }
    }

    class FrameVisibilityListener
    extends ComponentAdapter {
        FrameVisibilityListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (e.getSource() == GuiController.this.moduleOverviewFrame) {
                GuiController.this.moduleOverviewClosed();
            } else if (e.getSource() == GuiController.this.moduleManagerFrame) {
                GuiController.this.moduleManagerClosed();
            } else if (e.getSource() == GuiController.this.loginFrame) {
                GuiController.this.loginClosed();
            }
        }
    }
}

