/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import au.com.bytecode.opencsv.CSVWriter;
import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVAccountDataExport {
    Logger logger = LoggerFactory.getLogger(CSVAccountDataExport.class);
    private List<String> baseProperties;
    private int basePropertiesSize;
    private List<String> accountProperties;
    private int accountPropertiesSize;

    public CSVAccountDataExport(DataService dataService) {
        this.initBaseProperties();
        this.initAccountProperties();
    }

    public File exportData(Module module) {
        try {
            File tmpFile = File.createTempFile("accountData", "csv");
            FileOutputStream fos = new FileOutputStream(tmpFile, false);
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"), ';');
            ArrayList<String> headers = new ArrayList<String>(this.baseProperties);
            headers.addAll(this.accountProperties);
            writer.writeNext(headers.toArray(new String[headers.size()]));
            List<String[]> moduleData = this.getDataForAccount(module);
            writer.writeAll(moduleData);
            writer.close();
            return tmpFile;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to write csv file", (Throwable)ioe);
            return null;
        }
    }

    private void initBaseProperties() {
        this.baseProperties = new ArrayList<String>();
        this.baseProperties.add("Account id");
        this.baseProperties.add("Account name");
        this.baseProperties.add("Account password");
        this.baseProperties.add("Account folder");
        this.basePropertiesSize = this.baseProperties.size();
    }

    private void initAccountProperties() {
        this.accountProperties = new ArrayList<String>();
        this.accountProperties.add("PROPERTY_NAME");
        this.accountProperties.add("PROPERTY_VALUE");
        this.accountPropertiesSize = this.accountProperties.size();
    }

    private String[] getBaseProperties(Module module) {
        UserAccountImpl account = (UserAccountImpl)module.getUserAccount();
        String[] baseProps = new String[]{account.getId() + "", account.getName(), account.getPassword(), account.getFolder().toString()};
        return baseProps;
    }

    private void addToData(List<String[]> data, String[] values) {
        if (values != null) {
            data.add(values);
        }
    }

    private List<String[]> getDataForAccount(Module module) {
        ArrayList<String[]> data = new ArrayList<String[]>(this.basePropertiesSize + this.accountPropertiesSize);
        this.addAccountProperties(module, data);
        return data;
    }

    private void addAccountProperties(Module module, List<String[]> data) {
        Map account = module.getUserAccount().getProperties();
        ArrayList<String> accountProps = null;
        Set entries = account.entrySet();
        for (Map.Entry entry : entries) {
            accountProps = new ArrayList<String>();
            accountProps.addAll(Arrays.asList(this.getBaseProperties(module)));
            accountProps.add((String)entry.getKey());
            accountProps.add((String)entry.getValue());
            this.addToData(data, accountProps.toArray(new String[accountProps.size()]));
        }
    }
}

