/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import au.com.bytecode.opencsv.CSVWriter;
import ch.tatool.data.DataContainer;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVSessionDataExport {
    Logger logger = LoggerFactory.getLogger(CSVSessionDataExport.class);
    private DataService dataService;
    private List<String> baseProperties;
    private int basePropertiesSize;
    private List<String> sessionProperties;
    private int sessionPropertiesSize;

    public CSVSessionDataExport(DataService dataService) {
        this.dataService = dataService;
        this.initBaseProperties();
    }

    public File exportData(Module module, int fromSessionIndex) {
        this.initSessionProperties(module);
        try {
            File tmpFile = File.createTempFile("sessionData", "csv");
            FileOutputStream fos = new FileOutputStream(tmpFile, false);
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"), ';');
            ArrayList<String> headers = new ArrayList<String>(this.baseProperties);
            headers.addAll(this.sessionProperties);
            writer.writeNext(headers.toArray(new String[headers.size()]));
            List sessions = this.dataService.getSessions(module);
            for (ModuleSession session : sessions) {
                if (fromSessionIndex >= 0 && session.getIndex() < fromSessionIndex) continue;
                List<String[]> sessionData = this.getDataForSession(session);
                writer.writeAll(sessionData);
            }
            writer.close();
            return tmpFile;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to write csv file", (Throwable)ioe);
            return null;
        }
    }

    private List<String[]> getDataForSession(ModuleSession session) {
        ArrayList<String[]> data = new ArrayList<String[]>(this.basePropertiesSize + this.sessionPropertiesSize);
        this.addSessionProperties(session, data);
        return data;
    }

    private void initBaseProperties() {
        this.baseProperties = new ArrayList<String>();
        this.baseProperties.add("Module id");
        this.baseProperties.add("Module name");
        this.baseProperties.add("Session id");
        this.baseProperties.add("Session index");
        this.baseProperties.add("Session start time");
        this.baseProperties.add("Session end time");
        this.basePropertiesSize = this.baseProperties.size();
    }

    private String[] getBaseProperties(ModuleSession session) {
        String[] baseProps = new String[6];
        baseProps[0] = session.getModule().getId().toString();
        baseProps[1] = session.getModule().getName();
        baseProps[2] = session.getId().toString();
        baseProps[3] = session.getIndex() + "";
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sessionStartTime = new StringBuilder("");
        StringBuilder sessionEndTime = new StringBuilder("");
        if (session.getStartTime() != null) {
            sessionStartTime = new StringBuilder(dateformat.format(session.getStartTime()));
        }
        if (session.getEndTime() != null) {
            sessionEndTime = new StringBuilder(dateformat.format(session.getEndTime()));
        }
        baseProps[4] = sessionStartTime.toString();
        baseProps[5] = sessionEndTime.toString();
        return baseProps;
    }

    private void addToData(List<String[]> data, String[] values) {
        if (values != null) {
            data.add(values);
        }
    }

    private void initSessionProperties(Module module) {
        this.sessionProperties = new ArrayList<String>();
        this.sessionProperties.add("ELEMENT_ID");
        this.sessionProperties.add("PROPERTY_NAME");
        this.sessionProperties.add("PROPERTY_VALUE");
        this.sessionPropertiesSize = this.sessionProperties.size();
    }

    private void addSessionProperties(ModuleSession session, List<String[]> data) {
        ArrayList<String> sessionProps = null;
        if (session.getEntries().isEmpty()) {
            sessionProps = new ArrayList<String>();
            sessionProps.addAll(Arrays.asList(this.getBaseProperties(session)));
            this.addToData(data, sessionProps.toArray(new String[sessionProps.size()]));
        } else {
            for (DataContainer.Entry p : session.getEntries()) {
                sessionProps = new ArrayList();
                sessionProps.addAll(Arrays.asList(this.getBaseProperties(session)));
                sessionProps.add(p.getNodeId());
                sessionProps.add(p.getName());
                sessionProps.add(p.getValue());
                this.addToData(data, sessionProps.toArray(new String[sessionProps.size()]));
            }
        }
    }
}

