/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import ch.tatool.app.export.DataExportService;
import ch.tatool.app.export.DataExporterErrorImpl;
import ch.tatool.app.gui.MessagesImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.export.DataExporter;
import ch.tatool.export.DataExporterError;
import java.awt.Component;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExportServiceImpl
implements DataExportService {
    Logger logger = LoggerFactory.getLogger(DataExportServiceImpl.class);
    private DataService dataService;
    private MessagesImpl messages;

    @Override
    public boolean exportConfigured(Module module, String exporterKey) {
        return module.getModuleExporter(exporterKey) != null;
    }

    @Override
    public boolean containsPendingExportData(Module module, String exporterKey) {
        if (!this.exportConfigured(module, exporterKey)) {
            return false;
        }
        ModuleSession session = this.dataService.getLastSession(module);
        if (session == null) {
            return false;
        }
        String lastExportSessionId = (String)module.getModuleProperties().get(exporterKey + "." + "last.session");
        return lastExportSessionId == null || !lastExportSessionId.equals(String.valueOf(session.getIndex()));
    }

    @Override
    public Date getLastExportDate(Module module, String exporterKey) {
        Date lastExportDate = null;
        if (!this.exportConfigured(module, exporterKey)) {
            return null;
        }
        String lastExportDateString = (String)module.getModuleProperties().get(exporterKey + "." + "last.timestamp");
        if (lastExportDateString != null && !lastExportDateString.isEmpty()) {
            lastExportDate = new Date(Long.parseLong(lastExportDateString));
        }
        return lastExportDate;
    }

    @Override
    public String exportData(Component parent, Module module, String exporterKey) {
        String s;
        DataExporter exporter = module.getModuleExporter(exporterKey);
        if (exporter == null) {
            throw new RuntimeException("Exporter not found");
        }
        if (exporter.getDataService() == null) {
            exporter.setDataService(this.dataService);
        }
        this.dataService.setMessages((Messages)this.messages);
        int fromSessionIndex = -1;
        boolean incremental = exporter.isIncrementalExport();
        if (incremental && (s = (String)module.getModuleProperties().get(exporterKey + "." + "last.session")) != null) {
            try {
                fromSessionIndex = Integer.parseInt(s);
                ++fromSessionIndex;
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("Unable to cast last session index to a number. Exporting all sessions", (Throwable)nfe);
            }
        }
        String error = null;
        DataExporterErrorImpl exporterError = new DataExporterErrorImpl();
        exporterError.setMessages(this.messages);
        try {
            error = exporter.exportData(parent, module, fromSessionIndex, (DataExporterError)exporterError);
            if (exporterError.getErrorType() != 0) {
                this.dataService.saveModule(module);
                return exporterError.getErrorMessage();
            }
            module.getModuleProperties().put(exporterKey + "." + "last.timestamp", String.valueOf(System.currentTimeMillis()));
            ModuleSession session = this.dataService.getLastSession(module);
            if (session != null) {
                module.getModuleProperties().put(exporterKey + "." + "last.session", String.valueOf(session.getIndex()));
            }
            this.dataService.saveModule(module);
        }
        catch (RuntimeException ioe) {
            this.logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return null;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void setMessages(MessagesImpl messages) {
        this.messages = messages;
    }

    public MessagesImpl getMessages() {
        return this.messages;
    }
}

