/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import ch.tatool.app.export.CSVAccountDataExport;
import ch.tatool.app.export.CSVModuleDataExport;
import ch.tatool.app.export.CSVSessionDataExport;
import ch.tatool.app.export.CSVTrialDataExport;
import ch.tatool.app.export.DataExporterImpl;
import ch.tatool.app.gui.MessagesImpl;
import ch.tatool.data.Module;
import ch.tatool.export.DataExporterError;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDataExporter
extends DataExporterImpl {
    Logger logger = LoggerFactory.getLogger(ServerDataExporter.class);
    public static final String PROPERTY_EXPORT_USERNAME = "username";
    public static final String PROPERTY_EXPORT_PASSWORD = "password";
    public String url;
    public MessagesImpl messages;
    public DataExporterError exporterError;

    @Override
    public String exportData(Component parentFrame, Module module, int fromSessionIndex, DataExporterError exporterError) {
        this.exporterError = exporterError;
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<File> tmpFiles = new ArrayList<File>();
        CSVTrialDataExport csvTrialExport = new CSVTrialDataExport(this.dataService);
        csvTrialExport.setCSVParameters(';');
        File tmpTrialFile = csvTrialExport.exportData(module, fromSessionIndex);
        CSVSessionDataExport csvSessionExport = new CSVSessionDataExport(this.dataService);
        File tmpSessionFile = csvSessionExport.exportData(module, fromSessionIndex);
        CSVModuleDataExport csvModuleExport = new CSVModuleDataExport(this.dataService);
        File tmpModuleFile = csvModuleExport.exportData(module);
        CSVAccountDataExport csvAccountExport = new CSVAccountDataExport(this.dataService);
        File tmpAccountFile = csvAccountExport.exportData(module);
        if (tmpTrialFile != null) {
            filenames.add("trialData");
            tmpFiles.add(tmpTrialFile);
        }
        if (tmpSessionFile != null) {
            filenames.add("sessionData");
            tmpFiles.add(tmpSessionFile);
        }
        if (tmpModuleFile != null) {
            filenames.add("moduleData");
            tmpFiles.add(tmpModuleFile);
        }
        if (tmpAccountFile != null) {
            filenames.add("accountData");
            tmpFiles.add(tmpAccountFile);
        }
        if (filenames.isEmpty()) {
            this.exporterError.setErrorType(1);
            return "Reason: No data to export";
        }
        HttpEntity httpEntity = this.getHttpEntity(module, fromSessionIndex, filenames, tmpFiles);
        if (httpEntity == null) {
            this.exporterError.setErrorType(11);
            return "Reason: Module is not properly configured for Tatool online.";
        }
        String error = this.uploadFiles(parentFrame, module, httpEntity);
        for (File f : tmpFiles) {
            f.delete();
        }
        return error;
    }

    private HttpEntity getHttpEntity(Module module, int fromSessionIndex, List<String> filenames, List<File> tmpFiles) {
        MultipartEntity entity = new MultipartEntity();
        Map moduleProperties = module.getModuleProperties();
        String subjectCode = (String)moduleProperties.get("tatool.online.subject.code");
        if (subjectCode == null || subjectCode.isEmpty()) {
            subjectCode = module.getUserAccount().getName();
        }
        String studyID = (String)moduleProperties.get("tatool.online.study.id");
        String moduleNr = (String)moduleProperties.get("tatool.online.module.nr");
        String groupNr = (String)moduleProperties.get("tatool.online.group.nr");
        for (int x = 0; x < filenames.size(); ++x) {
            String filename = filenames.get(x);
            File file = tmpFiles.get(x);
            FileBodyExt fileBody = new FileBodyExt(file);
            fileBody.setFilename(filename);
            entity.addPart("file" + x, (ContentBody)fileBody);
        }
        try {
            Charset utf8CharSet = Charset.forName("UTF-8");
            entity.addPart("fromSessionIndex", (ContentBody)new StringBody(String.valueOf(fromSessionIndex), utf8CharSet));
            entity.addPart("subjectCode", (ContentBody)new StringBody(subjectCode, utf8CharSet));
            entity.addPart("studyID", (ContentBody)new StringBody(studyID, utf8CharSet));
            entity.addPart("moduleNr", (ContentBody)new StringBody(moduleNr, utf8CharSet));
            entity.addPart("groupNr", (ContentBody)new StringBody(groupNr, utf8CharSet));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Unable to set write form parts", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Missing settings for tatool online", (Throwable)e);
            return null;
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFiles(Component parentFrame, Module module, HttpEntity httpEntity) {
        String password;
        String serverUrl = this.getUrl();
        if (serverUrl == null) {
            this.exporterError.setErrorType(12);
            return "Reason: No upload server url defined";
        }
        String username = (String)module.getModuleProperties().get(PROPERTY_EXPORT_USERNAME);
        if (username == null) {
            username = "anonymous";
        }
        if ((password = (String)module.getModuleProperties().get(PROPERTY_EXPORT_PASSWORD)) == null) {
            password = "anonymous";
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)0);
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
        HttpPost httpPost = new HttpPost(serverUrl);
        httpPost.setEntity(httpEntity);
        try {
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                this.exporterError.setErrorType(13);
                this.exporterError.setErrorReason(response.getStatusLine().getReasonPhrase() + " (" + response.getStatusLine().getStatusCode() + ")");
                String string = "Reason: " + response.getStatusLine().getReasonPhrase() + " (" + response.getStatusLine().getStatusCode() + ")";
                return string;
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Upload server response: {}", (Object)result);
            }
        }
        catch (IOException ioe) {
            httpclient.getConnectionManager().shutdown();
            this.logger.error("Unable to upload data", (Throwable)ioe);
            this.exporterError.setErrorType(2);
            this.exporterError.setErrorReason(ioe.toString() + ": " + ioe.getMessage());
            String string = "Reason: " + ioe.toString() + ": " + ioe.getMessage();
            return string;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getExporterName() {
        return "Upload";
    }

    class FileBodyExt
    extends FileBody {
        String fileNameOverwrite;

        public FileBodyExt(File file) {
            super(file);
            this.fileNameOverwrite = null;
        }

        public void setFilename(String fileNameOverwrite) {
            this.fileNameOverwrite = fileNameOverwrite;
        }

        public String getFilename() {
            if (this.fileNameOverwrite != null) {
                return this.fileNameOverwrite;
            }
            return super.getFilename();
        }
    }
}

