/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.app.GuiController;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.module.ModuleCreator;
import ch.tatool.module.ModuleCreatorRegistry;
import ch.tatool.module.ModuleService;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManagerFrame
extends JFrame {
    Logger logger = LoggerFactory.getLogger(ModuleManagerFrame.class);
    public static final String DEFAULT_MODULE_ID = "default.module.id";
    private static final long serialVersionUID = -4668990416882096902L;
    private UserAccountService userAccountService;
    private ModuleService moduleService;
    private ModuleCreatorRegistry moduleCreatorRegistry;
    private GuiController guiController;
    private DefaultListModel listModel;
    private UserAccount account;
    private ModuleCreator currentCreator;
    private Messages messages;
    private JButton deleteTrainingButton;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JList moduleList;
    private JButton openTrainingButton;
    private JButton selectCreatorButton;

    public ModuleManagerFrame() {
        this.logger.info("Create new instance of ModuleManagerFrame");
    }

    public void init() {
        this.listModel = new DefaultListModel();
    }

    public void initialize(UserAccount account) {
        this.account = account;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.openTrainingButton);
        this.initData();
        this.pack();
        this.setLocationRelativeTo(null);
        URL iconUrl = this.getClass().getResource("/ch/tatool/app/gui/icon.png");
        Image icon = this.getToolkit().getImage(iconUrl);
        this.setIconImage(icon);
    }

    public void initData() {
        this.listModel.removeAllElements();
        Set modules = this.moduleService.getModules(this.account);
        for (Module.Info t : modules) {
            this.listModel.addElement(t);
        }
        this.moduleList.setSelectedIndex(0);
        this.selectCreatorButton.setEnabled(!this.moduleCreatorRegistry.getCreators().isEmpty());
    }

    private void deleteModule() {
        Module.Info moduleInfo = (Module.Info)this.moduleList.getSelectedValue();
        if (moduleInfo == null) {
            return;
        }
        Object[] options = new Object[]{this.messages.getString("General.okLabel"), this.messages.getString("General.cancelLabel")};
        int result = JOptionPane.showOptionDialog(this, this.messages.getString("ModuleManagerFrame.label.confirmDelete") + " '" + moduleInfo.toString() + "'", this.messages.getString("General.errorMessage.windowTitle.warning"), -1, 2, null, options, options[0]);
        if (result == 0) {
            this.moduleService.deleteModule(moduleInfo);
            this.initData();
        }
    }

    private void openSelectedModule() {
        Module.Info moduleInfo = (Module.Info)this.moduleList.getSelectedValue();
        if (moduleInfo == null) {
            return;
        }
        Module module = this.moduleService.loadModule(moduleInfo);
        this.openModule(module);
    }

    private void openModule(Module module) {
        this.account.getProperties().put("LastLoadedModule", module.getId().toString());
        this.userAccountService.saveAccount(this.account);
        this.guiController.setModule(module);
    }

    private void showCreatorMenu() {
        ActionListener menuReactor = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JMenuItem source = (JMenuItem)evt.getSource();
                ModuleManagerFrame.this.openCreator(source.getActionCommand());
            }
        };
        JPopupMenu creatorPopupMenu = new JPopupMenu();
        for (ModuleCreator creator : this.moduleCreatorRegistry.getCreators()) {
            creator.setMessages(this.messages);
            JMenuItem item = new JMenuItem(creator.getCreatorName());
            item.setActionCommand(creator.getCreatorId());
            item.addActionListener(menuReactor);
            creatorPopupMenu.add(item);
        }
        creatorPopupMenu.pack();
        creatorPopupMenu.show(this.selectCreatorButton, 0, this.selectCreatorButton.getHeight());
    }

    private void openCreator(String creatorId) {
        if (this.currentCreator != null) {
            this.currentCreator.hideCreator();
            this.currentCreator = null;
        }
        this.currentCreator = this.moduleCreatorRegistry.getCreatorById(creatorId);
        if (this.currentCreator == null) {
            return;
        }
        ModuleCreator.Callback callback = new ModuleCreator.Callback(){

            public void closeDialog(Module newlyCreatedModule) {
                ModuleManagerFrame.this.currentCreator.hideCreator();
                ModuleManagerFrame.this.currentCreator = null;
                if (newlyCreatedModule != null) {
                    ModuleManagerFrame.this.openModule(newlyCreatedModule);
                }
            }
        };
        this.currentCreator.executeCreator((JFrame)this, this.account, this.moduleService, callback);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.currentCreator != null) {
            this.currentCreator.hideCreator();
            this.currentCreator = null;
        }
        super.setVisible(visible);
    }

    public ModuleService getModuleService() {
        return this.moduleService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    public void setGuiController(GuiController guiController) {
        this.guiController = guiController;
    }

    public UserAccount getAccount() {
        return this.account;
    }

    public void setAccount(UserAccount account) {
        this.account = account;
    }

    public UserAccountService getUserAccountService() {
        return this.userAccountService;
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public ModuleCreatorRegistry getModuleCreatorRegistry() {
        return this.moduleCreatorRegistry;
    }

    public void setModuleCreatorRegistry(ModuleCreatorRegistry moduleCreatorRegistry) {
        this.moduleCreatorRegistry = moduleCreatorRegistry;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void initComponents() {
        this.getContentPane().removeAll();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.moduleList = new JList();
        this.openTrainingButton = new JButton();
        this.selectCreatorButton = new JButton();
        this.deleteTrainingButton = new JButton();
        this.setTitle(this.messages.getString("General.title"));
        this.setResizable(false);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, this.messages.getString("ModuleManagerFrame.labelTitle.myModules"), 0, 0, new Font("Tahoma", 1, 14)));
        this.moduleList.setFont(this.moduleList.getFont().deriveFont((float)this.moduleList.getFont().getSize() + 3.0f));
        this.moduleList.setModel(this.listModel);
        this.moduleList.setSelectionMode(0);
        this.moduleList.setVisibleRowCount(10);
        this.moduleList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModuleManagerFrame.this.moduleListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.moduleList);
        this.openTrainingButton.setText(this.messages.getString("ModuleManagerFrame.label.openModule"));
        this.openTrainingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleManagerFrame.this.openTrainingButtonActionPerformed(evt);
            }
        });
        this.selectCreatorButton.setText(this.messages.getString("ModuleManagerFrame.label.addModule"));
        this.selectCreatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleManagerFrame.this.selectCreatorButtonActionPerformed(evt);
            }
        });
        this.deleteTrainingButton.setText(this.messages.getString("ModuleManagerFrame.label.deleteModule"));
        this.deleteTrainingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleManagerFrame.this.deleteTrainingButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 274, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.selectCreatorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteTrainingButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE).addComponent(this.openTrainingButton))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectCreatorButton).addComponent(this.deleteTrainingButton).addComponent(this.openTrainingButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void selectCreatorButtonActionPerformed(ActionEvent evt) {
        this.showCreatorMenu();
    }

    private void deleteTrainingButtonActionPerformed(ActionEvent evt) {
        this.deleteModule();
    }

    private void moduleListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.openSelectedModule();
        }
    }

    private void openTrainingButtonActionPerformed(ActionEvent evt) {
        this.openSelectedModule();
    }
}

