/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.element.Element;
import ch.tatool.element.ElementTree;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhaseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ElementTreeImpl
implements ElementTree {
    private Element rootElement;
    private LinkedList<Element> stack = new LinkedList();
    private List<Element> immutableStack = Collections.unmodifiableList(this.stack);

    public List<Element> getElementStack() {
        return this.immutableStack;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Element element) {
        this.rootElement = element;
        this.stack.clear();
    }

    public void popElement() {
        if (!this.stack.isEmpty()) {
            this.stack.removeLast();
        }
    }

    public void pushElement(Element elementToPush) {
        if (elementToPush != null) {
            this.stack.add(elementToPush);
        }
    }

    public void clear() {
        this.stack.clear();
        this.rootElement = null;
    }

    public Element getTop() {
        if (!this.stack.isEmpty()) {
            return this.stack.getLast();
        }
        return null;
    }

    public void deliverPhaseEvent(ExecutionContext executionContext) {
        switch (executionContext.getPhase()) {
            case SESSION_START: 
            case SESSION_FINISH: {
                this.fireToTree(executionContext, this.rootElement);
                break;
            }
            case PRE_PROCESS: 
            case POST_PROCESS: {
                this.fireToStack(executionContext, this.stack);
            }
        }
    }

    private void fireToTree(ExecutionContext context, Element element) {
        this.fireToElement(context, element);
        for (Element child : element.getChildren()) {
            this.fireToTree(context, child);
        }
    }

    private void fireToStack(final ExecutionContext context, final List<Element> stack) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (Element element : stack) {
                        ElementTreeImpl.this.fireToElement(context, element);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void fireToElement(ExecutionContext context, Element element) {
        if (element.getExecutable() != null && element.getExecutable() instanceof ExecutionPhaseListener) {
            ((ExecutionPhaseListener)element.getExecutable()).processExecutionPhase(context);
        }
        for (Object handler : element.getHandlers()) {
            if (!(handler instanceof ExecutionPhaseListener)) continue;
            ((ExecutionPhaseListener)handler).processExecutionPhase(context);
        }
    }
}

