/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.app.data.ModuleSessionImpl;
import ch.tatool.app.service.impl.ModuleDAO;
import ch.tatool.data.DataService;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.Trial;
import ch.tatool.element.Node;
import java.util.Date;
import java.util.List;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class DataServiceImpl
implements DataService {
    private Messages messages;

    public void saveModule(Module module) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        moduleImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                ModuleDAO moduleDAO = moduleImpl.getModuleDAO();
                moduleDAO.saveModule(moduleImpl);
            }
        });
    }

    public ModuleSession createSession(Module module) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        ModuleSession moduleSession = (ModuleSession)moduleImpl.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ModuleSessionImpl moduleSession = new ModuleSessionImpl();
                moduleSession.setStartTime(new Date());
                moduleImpl.getSessionDAO().saveSession(moduleImpl, moduleSession);
                return moduleSession;
            }
        });
        return moduleSession;
    }

    public void saveSession(final ModuleSession moduleSession) {
        final ModuleImpl moduleImpl = (ModuleImpl)moduleSession.getModule();
        moduleImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                moduleImpl.getSessionDAO().saveSession(moduleImpl, moduleSession);
            }
        });
    }

    public void finishSession(final ModuleSession moduleSession) {
        final ModuleImpl moduleImpl = (ModuleImpl)moduleSession.getModule();
        moduleImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                moduleSession.setEndTime(new Date());
                moduleImpl.getSessionDAO().saveSession(moduleImpl, moduleSession);
            }
        });
    }

    public List<ModuleSession> getSessions(Module module) {
        return ((ModuleImpl)module).getSessionDAO().getSessions((ModuleImpl)module);
    }

    public void insertTrial(final ModuleSession session, final Trial trial) {
        final ModuleImpl moduleImpl = (ModuleImpl)session.getModule();
        moduleImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                moduleImpl.getTrialDAO().saveTrial(moduleImpl, session, trial);
            }
        });
    }

    public List<Trial> getTrials(ModuleSession session) {
        return ((ModuleImpl)session.getModule()).getTrialDAO().getTrials(session);
    }

    public List<Trial> loadAllTrials(Module module) {
        return ((ModuleImpl)module).getTrialDAO().loadAllTrials((ModuleImpl)module);
    }

    public List<Trial> getTrials(Module module, ModuleSession session, Node node, int maxResults) {
        return ((ModuleImpl)module).getTrialDAO().getTrials(session, node, maxResults);
    }

    public ModuleSession getLastSession(Module module) {
        return ((ModuleImpl)module).getSessionDAO().findLastSession((ModuleImpl)module);
    }

    public long getSessionCount(Module module, final boolean includeUnfinished) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        return (Long)moduleImpl.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return moduleImpl.getSessionDAO().getSessionCount(moduleImpl, includeUnfinished);
            }
        });
    }

    public List<Trial> getTrials(Module module, final ModuleSession session, final String elementNameLike, final String propertyNameLike, final int offset, final int maxResults) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        return (List)moduleImpl.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return moduleImpl.getTrialDAO().getTrials(moduleImpl, session, elementNameLike, propertyNameLike, offset, maxResults);
            }
        });
    }

    public List<Object[]> findDistinctTrialPropertyNames(Module module) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        return (List)moduleImpl.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return moduleImpl.getTrialDAO().findDistinctTrialPropertyNames(moduleImpl);
            }
        });
    }

    public List<Object[]> findDistinctSessionPropertyNames(Module module) {
        final ModuleImpl moduleImpl = (ModuleImpl)module;
        return (List)moduleImpl.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return moduleImpl.getSessionDAO().findDistinctSessionPropertyNames(moduleImpl);
            }
        });
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

