/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.app.data.ModuleSessionImpl;
import ch.tatool.app.data.TrialImpl;
import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.app.service.impl.ModuleInfoImpl;
import ch.tatool.data.Module;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ModuleDAO
extends HibernateDaoSupport {
    public Set<Module.Info> getModules(final UserAccountImpl account) {
        return (Set)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery("select module.id, module.name FROM ModuleImpl as module where module.accountId = :accountId");
                query.setParameter("accountId", (Object)account.getId());
                List results = query.list();
                TreeSet<ModuleInfoImpl> infos = new TreeSet<ModuleInfoImpl>();
                for (Object[] result : results) {
                    ModuleInfoImpl info = new ModuleInfoImpl();
                    info.setAccount(account);
                    info.setId((Long)result[0]);
                    info.setName((String)result[1]);
                    infos.add(info);
                }
                return infos;
            }
        });
    }

    public ModuleImpl loadModule(ModuleInfoImpl moduleInfo) {
        ModuleImpl module = (ModuleImpl)this.getHibernateTemplate().get(ModuleImpl.class, (Serializable)moduleInfo.getId());
        if (!moduleInfo.getAccount().getId().equals(module.getAccountId())) {
            throw new RuntimeException("ModuleInfo and Module object don't belong to each other! Account id mismatch");
        }
        module.setAccount(moduleInfo.getAccount());
        return module;
    }

    public void deleteModule(final ModuleInfoImpl moduleInfo) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                List trialIds = session.createQuery("select id from TrialImpl trial where trial.session.module.id = :id").setParameter("id", (Object)moduleInfo.getId()).list();
                for (Object o : trialIds) {
                    TrialImpl trial = new TrialImpl();
                    session.load((Object)trial, (Serializable)((Long)o));
                    session.delete((Object)trial);
                }
                session.flush();
                List sessionIds = session.createQuery("select id from ModuleSessionImpl session where session.module.id = :id").setParameter("id", (Object)moduleInfo.getId()).list();
                for (Object o : sessionIds) {
                    ModuleSessionImpl s = new ModuleSessionImpl();
                    session.load((Object)s, (Serializable)((Long)o));
                    session.delete((Object)s);
                }
                ModuleImpl module = ModuleDAO.this.loadModule(moduleInfo);
                session.delete((Object)module);
                return null;
            }
        });
    }

    public void addModuleProperties(final ModuleImpl impl, final Map<String, String> properties) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                session.update((Object)impl);
                Map<String, String> props = impl.getModuleProperties();
                for (String key : props.keySet()) {
                    ModuleDAO.this.logger.debug((Object)(key + ": " + props.get(key)));
                }
                for (String key : properties.keySet()) {
                    String value = (String)properties.get(key);
                    props.put(key, value);
                }
                session.save((Object)impl);
                return null;
            }
        });
    }

    private boolean existsModuleId(final Long id) {
        return (Boolean)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery("select module.id FROM ModuleImpl as module where module.id = ?");
                query.setLong(0, id.longValue());
                List results = query.list();
                if (results.size() > 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public void saveModule(ModuleImpl module) {
        this.getHibernateTemplate().saveOrUpdate((Object)module);
    }

    public void deleteModule(Module module) {
        this.getHibernateTemplate().delete((Object)module);
    }
}

