/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ModuleSessionDAO
extends HibernateDaoSupport {
    public List<ModuleSession> getSessions(final ModuleImpl module) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                String queryString = "select session from ModuleSessionImpl session where session.module = :module order by session.id";
                Query query = session.createQuery(queryString);
                query.setParameter("module", (Object)module);
                List result = query.list();
                for (ModuleSession s : result) {
                    s.setModule((Module)module);
                }
                return result;
            }
        });
    }

    private Integer findLastSessionIndex(final ModuleImpl module) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                String queryString = "select max(session.index) from ModuleSessionImpl session where session.module = :module";
                Query query = session.createQuery(queryString);
                query.setParameter("module", (Object)module);
                Integer result = (Integer)query.uniqueResult();
                if (result != null) {
                    return result;
                }
                return 0;
            }
        });
    }

    public void saveSession(ModuleImpl module, ModuleSession session) {
        if (session.getId() == null) {
            session.setModule((Module)module);
            session.setIndex(this.findLastSessionIndex(module) + 1);
            this.getHibernateTemplate().save((Object)session);
        } else {
            this.getHibernateTemplate().update((Object)session);
        }
    }

    public void deleteSession(ModuleImpl module, ModuleSession session) {
        this.getHibernateTemplate().delete((Object)session);
    }

    public ModuleSession findLastSession(final ModuleImpl module) {
        return (ModuleSession)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Criteria criteria = session.createCriteria(ModuleSession.class);
                criteria.add((Criterion)Restrictions.eq((String)"module", (Object)module));
                criteria.setFetchSize(1);
                criteria.addOrder(Order.desc((String)"id"));
                List sessions = criteria.list();
                if (sessions.size() > 0) {
                    return sessions.get(0);
                }
                return null;
            }
        });
    }

    public Long getSessionCount(final ModuleImpl module, final boolean includeUnfinished) {
        return (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                String query = "select count(session) from ModuleSessionImpl session where session.module = :module";
                if (!includeUnfinished) {
                    query = query + " and session.endTime != null";
                }
                return (Long)session.createQuery(query).setParameter("module", (Object)module).uniqueResult();
            }
        });
    }

    public List<Object[]> findDistinctSessionPropertyNames(final ModuleImpl module) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                StringBuilder queryString = new StringBuilder();
                queryString.append("Select distinct(entry.nodeId), entry.name").append(" from ModuleSessionImpl session left join session.entriesImpl entry").append(" where session.module = :module").append(" and entry.nodeId is not NULL").append(" order by entry.nodeId, entry.name");
                Query query = session.createQuery(queryString.toString());
                query.setParameter("module", (Object)module);
                return query.list();
            }
        });
    }
}

