/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.app.service.impl.UserAccountDAO;
import ch.tatool.app.util.ContextUtils;
import ch.tatool.data.Messages;
import ch.tatool.data.UserAccount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.hibernate.ObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class UserAccountServiceImpl
implements UserAccountService {
    Logger logger = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private static final String configurationFilePath = "ch/tatool/app/service/impl/account-context.xml";
    private String descriptionFileName = "account.properties";
    private String dataDirName = ".tatooldata";
    private boolean relativeToHome = true;
    private Messages messages;

    @Override
    public UserAccount createAccount(String accountName, Map<String, String> userProperties, String password) {
        List<UserAccount.Info> accounts = this.getAccounts();
        for (int i = 0; i < accounts.size(); ++i) {
            if (!accounts.get(i).getName().equals(accountName)) continue;
            return null;
        }
        File folder = this.createAccountFolder();
        UserAccountImpl.InfoImpl info = new UserAccountImpl.InfoImpl();
        info.setFolder(folder);
        info.setName(accountName);
        info.setPasswordProtected(password != null && password.length() > 0);
        UserAccountImpl account = (UserAccountImpl)this.loadAccount(info, null);
        info.setId(account.getId());
        this.writeAccountDescFile(info);
        if (password != null && password.length() > 0) {
            this.changePassword(account, password);
        }
        for (String s : userProperties.keySet()) {
            account.getProperties().put(s, userProperties.get(s));
        }
        this.saveAccount(account);
        this.changeLocale(account);
        return account;
    }

    @Override
    public UserAccount loadAccount(UserAccount.Info info, String password) {
        UserAccountImpl.InfoImpl infoImpl = (UserAccountImpl.InfoImpl)info;
        Properties properties = new Properties();
        String dataPath = new File(infoImpl.getFolder(), "data").getAbsolutePath();
        properties.setProperty("account.data.folder", dataPath);
        if (password != null && password.length() > 0) {
            properties.setProperty("account.password", password);
        } else {
            properties.setProperty("account.password", "");
        }
        BeanFactory beanFactory = ContextUtils.createBeanFactory(configurationFilePath, properties);
        final UserAccountImpl userAccount = new UserAccountImpl();
        userAccount.setFolder(infoImpl.getFolder());
        userAccount.setBeanFactory(beanFactory);
        userAccount.setPassword(password);
        userAccount.setName(infoImpl.getName());
        userAccount.setId(infoImpl.getId());
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)beanFactory.getBean("userAccountTxManager");
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        userAccount.setTransactionTemplate(transactionTemplate);
        try {
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    UserAccountDAO userAccountDAO = userAccount.getUserAccountDAO();
                    userAccountDAO.loadAccount(userAccount);
                }
            });
        }
        catch (ObjectNotFoundException onfe) {
            this.logger.warn("Databasee entry for account does not exist anymore. Got the database deleted?");
            throw new RuntimeException("Unable to load user account due to missing data");
        }
        this.changeLocale(userAccount);
        return userAccount;
    }

    private void changeLocale(UserAccountImpl account) {
        String lang = account.getProperties().get("userLanguage");
        if (lang == null) {
            lang = "en";
        }
        Locale local = new Locale(lang);
        this.messages.setLocale(local);
    }

    @Override
    public void saveAccount(UserAccount account) {
        final UserAccountImpl userAccount = (UserAccountImpl)account;
        userAccount.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                UserAccountDAO userAccountDAO = userAccount.getUserAccountDAO();
                userAccountDAO.saveAccount(userAccount);
            }
        });
        this.updateUserAccountInfo(userAccount);
    }

    @Override
    public void closeAccount(UserAccount account) {
        final UserAccountImpl userAccount = (UserAccountImpl)account;
        userAccount.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                UserAccountDAO userAccountDAO = userAccount.getUserAccountDAO();
                userAccountDAO.shutdown();
            }
        });
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)userAccount.getBeanFactory();
        beanFactory.destroySingletons();
    }

    @Override
    public void changePassword(UserAccount account, final String newPassword) {
        final UserAccountImpl userAccount = (UserAccountImpl)account;
        userAccount.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                UserAccountDAO userAccountDAO = userAccount.getUserAccountDAO();
                userAccountDAO.setAccountPassword(userAccount, newPassword);
            }
        });
        this.updateUserAccountInfo(userAccount);
    }

    @Override
    public void deleteAccount(UserAccount account) {
        final UserAccountImpl userAccount = (UserAccountImpl)account;
        userAccount.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                UserAccountDAO userAccountDAO = userAccount.getUserAccountDAO();
                userAccountDAO.deleteAccount(userAccount);
            }
        });
        this.closeAccount(account);
        File folder = userAccount.getFolder();
        if (folder.exists()) {
            try {
                this.logger.info("Deleting directory {}", (Object)folder.getAbsolutePath());
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException ioe) {
                this.logger.error("Unable to delete module directory!", (Throwable)ioe);
            }
        }
    }

    @Override
    public List<UserAccount.Info> getAccounts() {
        File[] children;
        File dataFolder = this.getTatoolDataFolder();
        ArrayList<UserAccount.Info> accounts = new ArrayList<UserAccount.Info>();
        for (File f : children = dataFolder.listFiles()) {
            if (!f.isDirectory()) continue;
            UserAccount.Info info = this.getAccountInfos(f);
            if (info != null) {
                accounts.add(info);
                continue;
            }
            this.logger.info("Non-project folder: {}", (Object)f.getAbsolutePath());
        }
        return accounts;
    }

    private UserAccount.Info getAccountInfos(File folder) {
        File descriptionFile = this.getAccountDescFile(folder);
        if (descriptionFile == null) {
            this.logger.info("No project description file exists for folder {}", (Object)folder);
            return null;
        }
        Properties p = this.readAccountDescFile(descriptionFile);
        if (p == null) {
            this.logger.info("Unable to read description file {}", (Object)descriptionFile.getAbsolutePath());
            return null;
        }
        UserAccountImpl.InfoImpl info = new UserAccountImpl.InfoImpl();
        info.setFolder(folder);
        info.setName(p.getProperty("name", "Unknown account name"));
        info.setPasswordProtected(Boolean.parseBoolean(p.getProperty("passwordProtected", "false")));
        String idString = p.getProperty("id");
        if (idString != null) {
            try {
                info.setId(Long.parseLong(idString));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("Unable to read account id", (Throwable)nfe);
            }
        }
        return info;
    }

    private void updateUserAccountInfo(UserAccountImpl userAccount) {
        UserAccountImpl.InfoImpl info = new UserAccountImpl.InfoImpl();
        info.setName(userAccount.getName());
        info.setPasswordProtected(userAccount.isPasswordProtected());
        info.setFolder(userAccount.getFolder());
        info.setId(userAccount.getId());
        this.writeAccountDescFile(info);
    }

    private Properties readAccountDescFile(File descFile) {
        try {
            FileInputStream fis = new FileInputStream(descFile);
            Properties p = new Properties();
            p.load(fis);
            fis.close();
            return p;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to read module description file", (Throwable)ioe);
            return null;
        }
    }

    private void writeAccountDescFile(UserAccountImpl.InfoImpl info) {
        File descriptionFile = this.createAccountDescFile(info);
        Properties p = new Properties();
        p.setProperty("name", info.getName());
        p.setProperty("passwordProtected", String.valueOf(info.isPasswordProtected()));
        p.setProperty("id", info.getId().toString());
        try {
            FileOutputStream fos = new FileOutputStream(descriptionFile);
            p.store(fos, "Tatool account info");
            fos.close();
        }
        catch (IOException ioe) {
            this.logger.error("Unable to write account info file", (Throwable)ioe);
        }
    }

    private File createAccountDescFile(UserAccountImpl.InfoImpl info) {
        File folder = info.getFolder();
        File descriptionFile = new File(folder, this.descriptionFileName);
        if (descriptionFile.exists()) {
            return descriptionFile;
        }
        this.logger.info("Creating description file {}", (Object)descriptionFile.getAbsolutePath());
        try {
            descriptionFile.createNewFile();
            return descriptionFile;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to create description file", (Throwable)ioe);
            return null;
        }
    }

    private File getAccountDescFile(File folder) {
        File descFile = new File(folder, this.descriptionFileName);
        if (descFile.exists()) {
            return descFile;
        }
        return null;
    }

    private File createAccountFolder() {
        File tatoolDataFolder = this.getTatoolDataFolder();
        File moduleFolder = null;
        while ((moduleFolder = new File(tatoolDataFolder, String.valueOf(System.currentTimeMillis()))).exists()) {
        }
        boolean created = moduleFolder.mkdirs();
        return created ? moduleFolder : null;
    }

    public File getTatoolDataFolder() {
        boolean created;
        File userHome = null;
        userHome = this.relativeToHome ? new File(System.getProperty("user.home")) : new File(".");
        File dataFolder = new File(userHome, this.dataDirName);
        if (!dataFolder.exists() && !(created = dataFolder.mkdirs())) {
            this.logger.error("Cannot create data directory: {}", (Object)dataFolder.getAbsolutePath());
            throw new RuntimeException("Unable to create data directory: " + dataFolder.getAbsolutePath());
        }
        return dataFolder;
    }

    public String getDataDirName() {
        return this.dataDirName;
    }

    public void setDataDirName(String dataDirName) {
        this.dataDirName = dataDirName;
    }

    public boolean isRelativeToHome() {
        return this.relativeToHome;
    }

    public void setRelativeToHome(boolean relativeToHome) {
        this.relativeToHome = relativeToHome;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

