/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import ch.tatool.app.export.CSVTrialDataExport;
import ch.tatool.app.export.DataExporterImpl;
import ch.tatool.data.Module;
import ch.tatool.export.DataExporterError;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataExporter
extends DataExporterImpl {
    Logger logger = LoggerFactory.getLogger(FileDataExporter.class);
    private String path;
    private boolean relativeToHome = false;

    @Override
    public String exportData(Component parentFrame, Module module, int fromSessionIndex, DataExporterError exporterError) {
        String filename = "";
        String path = this.getPath();
        if (path == null) {
            filename = this.getStorageDirectory(parentFrame);
        } else {
            Date d = new Date();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String account = FileDataExporter.removeSpecialCharacters(module.getUserAccount().getName());
            String moduleName = FileDataExporter.removeSpecialCharacters(module.getName());
            filename = this.relativeToHome ? System.getProperty("user.home") + System.getProperty("file.separator") + path + System.getProperty("file.separator") + moduleName + "_" + account + "_" + dateformat.format(d) + ".csv" : path + System.getProperty("file.separator") + moduleName + "_" + account + "_" + dateformat.format(d) + ".csv";
        }
        CSVTrialDataExport csvExport = new CSVTrialDataExport(this.dataService);
        if (this.dataService.getMessages().getLocale().getLanguage().equals("en")) {
            csvExport.setCSVParameters(',');
        } else {
            csvExport.setCSVParameters(';');
        }
        File tmpFile = csvExport.exportData(module, fromSessionIndex);
        if (filename == null) {
            exporterError.setErrorType(3);
            return "The export has been cancelled.";
        }
        try {
            File moduleDataFile = new File(filename);
            FileUtils.copyFile((File)tmpFile, (File)moduleDataFile);
            tmpFile.delete();
        }
        catch (IOException ioe) {
            this.logger.error("Unable to move exported file to destination", (Throwable)ioe);
            exporterError.setErrorType(21);
            exporterError.setErrorReason(ioe.getMessage());
            return "Export failed.\n" + ioe.getMessage();
        }
        return null;
    }

    public static String removeSpecialCharacters(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (!(str.charAt(i) >= '0' && str.charAt(i) <= '9' || str.charAt(i) >= 'A' && str.charAt(i) <= 'z' || str.charAt(i) == '.') && str.charAt(i) != '_') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    private String getStorageDirectory(Component parentFrame) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "CSV (*.csv)";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileDataExporter.getExtension(f);
                if (extension != null) {
                    return extension.equals("csv");
                }
                return false;
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showSaveDialog(parentFrame);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            String filename = "";
            if (f == null) {
                throw new RuntimeException();
            }
            String extension = FileDataExporter.getExtension(f);
            filename = extension == null || !FileDataExporter.getExtension(f).equals("csv") ? f + ".csv" : f.getPath();
            return filename;
        }
        return null;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isRelativeToHome() {
        return this.relativeToHome;
    }

    public void setRelativeToHome(boolean relativeToHome) {
        this.relativeToHome = relativeToHome;
    }

    @Override
    public String getExporterName() {
        return "Export";
    }
}

