/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.app.service.exec.PhaseListenerManager;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.ExecutionPhaseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseListenerManagerImpl
implements PhaseListenerManager {
    private Logger logger = LoggerFactory.getLogger(PhaseListenerManagerImpl.class);
    private Map<ExecutionPhaseListener, Set<ExecutionPhase>> moduleExecutionListeners = new HashMap<ExecutionPhaseListener, Set<ExecutionPhase>>();
    private Map<ExecutionPhase, Set<ExecutionPhaseListener>> phasesToListeners = new HashMap<ExecutionPhase, Set<ExecutionPhaseListener>>();

    @Override
    public Set<ExecutionPhase> getPhaseListenerPhases(ExecutionPhaseListener listener) {
        Set<ExecutionPhase> phases = this.moduleExecutionListeners.get(listener);
        if (phases != null) {
            return Collections.unmodifiableSet(phases);
        }
        return Collections.emptySet();
    }

    @Override
    public void addExecutionPhaseListener(ExecutionPhaseListener listener, Set<ExecutionPhase> phases) {
        if (listener != null && phases != null) {
            for (ExecutionPhase phase : phases) {
                this.addExecutionPhaseListenerImpl(listener, phase);
            }
        }
    }

    @Override
    public void addExecutionPhaseListener(ExecutionPhaseListener listener, ExecutionPhase phase) {
        this.addExecutionPhaseListenerImpl(listener, phase);
    }

    private void addExecutionPhaseListenerImpl(ExecutionPhaseListener listener, ExecutionPhase phase) {
        if (listener == null || phase == null) {
            return;
        }
        Set<ExecutionPhase> phases = this.moduleExecutionListeners.get(listener);
        if (phases == null) {
            phases = new HashSet<ExecutionPhase>();
            this.moduleExecutionListeners.put(listener, phases);
        }
        phases.add(phase);
        Set<ExecutionPhaseListener> listeners = this.phasesToListeners.get(phase);
        if (listeners == null) {
            listeners = new HashSet<ExecutionPhaseListener>();
            this.phasesToListeners.put(phase, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeExecutionPhaseListener(ExecutionPhaseListener listener) {
        this.removeExecutionPhaseListener(listener, this.moduleExecutionListeners.get(listener));
    }

    @Override
    public void removeExecutionPhaseListener(ExecutionPhaseListener listener, ExecutionPhase phase) {
        this.removeExecutionPhaseListenerImpl(listener, phase);
    }

    @Override
    public void removeExecutionPhaseListener(ExecutionPhaseListener listener, Set<ExecutionPhase> phases) {
        if (listener != null && phases != null) {
            for (ExecutionPhase phase : phases) {
                this.removeExecutionPhaseListenerImpl(listener, phase);
            }
        }
    }

    private void removeExecutionPhaseListenerImpl(ExecutionPhaseListener listener, ExecutionPhase phase) {
        if (listener == null || phase == null) {
            return;
        }
        Set<ExecutionPhase> phases = this.moduleExecutionListeners.get(listener);
        if (phases == null) {
            return;
        }
        if (!phases.remove(phase)) {
            return;
        }
        if (phases.isEmpty()) {
            this.moduleExecutionListeners.remove(listener);
        }
        Set<ExecutionPhaseListener> listeners = this.phasesToListeners.get(phase);
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            this.phasesToListeners.remove(phase);
        }
    }

    @Override
    public void informListeners(ExecutionContext context) {
        Set<ExecutionPhaseListener> listeners;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(System.currentTimeMillis() + ": Distributing context for phase " + context.getPhase());
        }
        if ((listeners = this.phasesToListeners.get(context.getPhase())) != null) {
            this.fireToExternals(context, listeners);
        }
    }

    private void fireToExternals(final ExecutionContext context, final Set<ExecutionPhaseListener> listeners) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (ExecutionPhaseListener listener : listeners) {
                        listener.processExecutionPhase(context);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

