/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.app.data.ModuleSessionImpl;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.Trial;
import ch.tatool.element.Node;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrialDAO {
    private SessionFactory sessionFactory;
    Logger logger = LoggerFactory.getLogger(TrialDAO.class);

    public List<Trial> loadAllTrials(ModuleImpl module) {
        String queryString = "select trial from TrialImpl trial where trial.session.module = :module";
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString);
        query.setParameter("module", (Object)module);
        return query.list();
    }

    public List<Trial> getTrials(ModuleSession moduleSession) {
        this.sessionFactory.getCurrentSession().update((Object)moduleSession);
        Query query = this.sessionFactory.getCurrentSession().createQuery("select trial from TrialImpl trial where trial.session = :session order by trial.id");
        query.setParameter("session", (Object)moduleSession);
        List trials = query.list();
        for (Trial t : trials) {
            t.setSession(moduleSession);
        }
        return trials;
    }

    public List<Trial> getTrials(ModuleImpl module, ModuleSession moduleSession, String elementNameLike, String propertyNameLike, int offset, int maxResults) {
        if (elementNameLike == null && propertyNameLike == null) {
            throw new RuntimeException("Either elementName or propertyName needs to be non-null");
        }
        this.sessionFactory.getCurrentSession().update((Object)module);
        if (moduleSession != null) {
            this.sessionFactory.getCurrentSession().update((Object)moduleSession);
        }
        StringBuilder q = new StringBuilder();
        q.append("select distinct(trial) from TrialImpl trial ");
        q.append(" join trial.entriesImpl as entry where ");
        if (moduleSession != null) {
            q.append(" trial.session = :session ");
        } else {
            q.append(" trial.session.module = :module ");
        }
        if (elementNameLike != null) {
            q.append(" and entry.nodeId like :elementName");
        }
        if (propertyNameLike != null) {
            q.append(" and entry.name like :propName");
        }
        q.append(" order by trial.id DESC");
        Query query = this.sessionFactory.getCurrentSession().createQuery(q.toString());
        if (moduleSession != null) {
            query.setParameter("session", (Object)moduleSession);
        } else {
            query.setParameter("module", (Object)module);
        }
        if (elementNameLike != null) {
            query.setParameter("elementName", (Object)elementNameLike);
        }
        if (propertyNameLike != null) {
            query.setParameter("propName", (Object)propertyNameLike);
        }
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (maxResults > -1) {
            query.setMaxResults(maxResults);
        }
        List trials = query.list();
        if (moduleSession != null) {
            for (Trial t : trials) {
                t.setSession(moduleSession);
            }
        }
        return trials;
    }

    public int getLastTrialIndex(ModuleSession moduleSession) {
        Query query = this.sessionFactory.getCurrentSession().createQuery("select max(trial.index) from TrialImpl trial where trial.session = :session");
        query.setParameter("session", (Object)moduleSession);
        List index = query.list();
        if (index != null && index.isEmpty()) {
            return 0;
        }
        return (Integer)index.get(0);
    }

    public void saveTrial(Module module, ModuleSession session, Trial trial) {
        ModuleSessionImpl sessionImpl = (ModuleSessionImpl)session;
        if (trial.getId() == null) {
            this.sessionFactory.getCurrentSession().update((Object)session);
            trial.setSession(session);
            sessionImpl.getTrials().add(trial);
            trial.setIndex(sessionImpl.getTrials().indexOf(trial));
            this.sessionFactory.getCurrentSession().save((Object)trial);
        } else {
            this.sessionFactory.getCurrentSession().update((Object)trial);
        }
    }

    public void deleteTrial(Module module, ModuleSession session, Trial trial) {
        Iterator<Trial> it = ((ModuleSessionImpl)session).getTrials().iterator();
        while (it.hasNext()) {
            Trial t = it.next();
            if (!t.getId().equals(trial.getId())) continue;
            it.remove();
        }
        this.sessionFactory.getCurrentSession().delete((Object)trial);
    }

    public List<Trial> getTrials(ModuleSession session, Node node, int maxResults) {
        List trials = null;
        DetachedCriteria criteria = DetachedCriteria.forClass(Trial.class);
        if (session != null) {
            criteria.add((Criterion)Property.forName((String)"session").eq((Object)session));
        }
        if (node != null) {
            criteria.add((Criterion)Property.forName((String)"nodeId").eq((Object)node.getId()));
        }
        criteria.addOrder(Order.desc((String)"id"));
        trials = criteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).setMaxResults(maxResults).list();
        return trials;
    }

    public List<Object[]> findDistinctTrialPropertyNames(ModuleImpl module) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("Select distinct(entry.nodeId), entry.name").append(" from TrialImpl trial left join trial.entriesImpl entry").append(" where trial.session.module = :module").append(" and entry.nodeId is not NULL").append(" order by entry.nodeId, entry.name");
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString());
        query.setParameter("module", (Object)module);
        return query.list();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

