/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app;

import ch.tatool.app.GuiController;
import ch.tatool.app.export.DataExportService;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.app.service.exec.ExecutionService;
import ch.tatool.app.service.impl.UserAccountServiceImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.exec.Executor;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ModuleService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class TestApp {
    protected String dataDirName = "testDataDir";
    private ApplicationContext ctx;

    public void startApplication() {
        this.ctx = new ClassPathXmlApplicationContext("/tatool/test-application-context.xml");
        UserAccountServiceImpl userAccountService = (UserAccountServiceImpl)this.getUserAccountService();
        userAccountService.setRelativeToHome(false);
        userAccountService.setDataDirName(this.dataDirName);
    }

    public void deleteData() {
        System.out.println("Deleting data folder...");
        File dataDir = ((UserAccountServiceImpl)this.getUserAccountService()).getTatoolDataFolder();
        try {
            FileUtils.deleteDirectory((File)dataDir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void runModule() {
        System.out.println("Initializing application...");
        this.startApplication();
        UserAccount account = this.createAccount();
        Module module = this.createModule(account);
        System.out.println("START: Executing module...");
        Executor executor = this.getExecutionService().createExecutor(module);
        this.getExecutionService().startExecution(executor, true);
        System.out.println("END:   Executing module.");
        this.getUserAccountService().deleteAccount(account);
        this.deleteData();
    }

    protected UserAccount createAccount() {
        return this.getUserAccountService().createAccount(String.valueOf(new Date().getTime()), this.createAccountProperties(), null);
    }

    protected Map<String, String> createAccountProperties() {
        HashMap<String, String> accountProperties = new HashMap<String, String>();
        return accountProperties;
    }

    protected Module createModule(UserAccount account) {
        Module module = this.getModuleService().createModule(account, this.createModuleProperties(), this.createBinaryModuleProperties(), this.createModuleExporters());
        return module;
    }

    protected Map<String, String> createModuleProperties() {
        HashMap<String, String> moduleProps = new HashMap<String, String>();
        moduleProps.put("module.name", "Test module");
        return moduleProps;
    }

    protected Map<String, byte[]> createBinaryModuleProperties() {
        HashMap<String, byte[]> props = new HashMap<String, byte[]>();
        return props;
    }

    protected Map<String, DataExporter> createModuleExporters() {
        HashMap<String, DataExporter> exporters = new HashMap<String, DataExporter>();
        return exporters;
    }

    public ApplicationContext getCtx() {
        return this.ctx;
    }

    public GuiController getGuiController() {
        return (GuiController)this.ctx.getBean("GuiController");
    }

    public ModuleService getModuleService() {
        return (ModuleService)this.ctx.getBean("ModuleService");
    }

    public UserAccountService getUserAccountService() {
        return (UserAccountService)this.ctx.getBean("UserAccountService");
    }

    public ExecutionService getExecutionService() {
        return (ExecutionService)this.ctx.getBean("ExecutionService");
    }

    public DataService getDataService() {
        return (DataService)this.ctx.getBean("DataService");
    }

    public DataExportService getDataExportService() {
        return (DataExportService)this.ctx.getBean("DataExportService");
    }
}

