/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.data;

import ch.tatool.app.data.DataEntryImpl;
import ch.tatool.data.DataContainer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DataContainerImpl
implements DataContainer {
    private Set<DataEntryImpl> entriesImpl = new HashSet<DataEntryImpl>();

    public Set<DataContainer.Entry> getEntries() {
        return Collections.unmodifiableSet(new HashSet<DataEntryImpl>(this.entriesImpl));
    }

    public Set<DataEntryImpl> getEntriesImpl() {
        return this.entriesImpl;
    }

    public void setEntriesImpl(Set<DataEntryImpl> entriesImpl) {
        this.entriesImpl = entriesImpl;
    }

    public String getValue(String item, String name) {
        DataEntryImpl entry = this.findEntry(this.entriesImpl, item, name);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public String putValue(String item, String name, String value) {
        return this.setEntry(this.entriesImpl, item, name, value);
    }

    public boolean containsValue(String item, String name) {
        DataEntryImpl prop = this.findEntry(this.entriesImpl, item, name);
        return prop != null;
    }

    private DataEntryImpl findEntry(Set<DataEntryImpl> properties, String item, String name) {
        for (DataEntryImpl prop : properties) {
            if (!prop.getNodeId().equals(item) || !prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    private String setEntry(Set<DataEntryImpl> properties, String item, String name, String value) {
        DataEntryImpl property = this.findEntry(properties, item, name);
        if (property != null) {
            String previousValue = property.getValue();
            property.setValue(value);
            return previousValue;
        }
        property = new DataEntryImpl();
        property.setNodeId(item);
        property.setName(name);
        property.setValue(value);
        properties.add(property);
        return null;
    }
}

