/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.data;

import ch.tatool.app.data.DataContainerImpl;
import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.app.service.impl.ModuleDAO;
import ch.tatool.app.service.impl.ModuleSessionDAO;
import ch.tatool.app.service.impl.TrialDAO;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.UserAccount;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ExecutorInitializer;
import ch.tatool.module.ModuleScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.support.TransactionTemplate;

public class ModuleImpl
extends DataContainerImpl
implements Module {
    private Long id;
    private Long accountId;
    private String name;
    private UserAccountImpl account;
    private ModuleScheduler moduleScheduler;
    private ExecutorInitializer executorConfiguration;
    private List<ModuleSession> sessions;
    private Map<String, String> moduleProperties = new HashMap<String, String>();
    private Map<String, DataExporter> moduleExporters;
    private Map<String, byte[]> binaryModuleProperties = new HashMap<String, byte[]>();
    private Messages messages;

    public ModuleImpl() {
        this.moduleExporters = new HashMap<String, DataExporter>();
        this.sessions = new ArrayList<ModuleSession>();
    }

    public ModuleDAO getModuleDAO() {
        return (ModuleDAO)this.account.getBeanFactory().getBean("moduleDAO");
    }

    public ModuleSessionDAO getSessionDAO() {
        return (ModuleSessionDAO)this.account.getBeanFactory().getBean("sessionDAO");
    }

    public TrialDAO getTrialDAO() {
        return (TrialDAO)this.account.getBeanFactory().getBean("trialDAO");
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.account.getTransactionTemplate();
    }

    public String toString() {
        return String.valueOf(this.getId() + " - " + this.getName());
    }

    public byte[] getBinaryModuleProperty(String propertyName) {
        return this.binaryModuleProperties.get(propertyName);
    }

    public Map<String, byte[]> getBinaryModuleProperties() {
        return this.binaryModuleProperties;
    }

    public void putBinaryModuleProperty(String id, byte[] value) {
        this.binaryModuleProperties.put(id, value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBinaryModuleProperties(Map<String, byte[]> largeModuleProperties) {
        this.binaryModuleProperties = largeModuleProperties;
    }

    public Map<String, String> getModuleProperties() {
        return this.moduleProperties;
    }

    public void setModuleProperties(Map<String, String> moduleProperties) {
        this.moduleProperties = moduleProperties;
    }

    public List<ModuleSession> getSessions() {
        return this.sessions;
    }

    public void setSessions(List<ModuleSession> sessions) {
        this.sessions = sessions;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public UserAccount getUserAccount() {
        return this.account;
    }

    public UserAccountImpl getAccount() {
        return this.account;
    }

    public void setAccount(UserAccountImpl account) {
        this.account = account;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleScheduler getModuleScheduler() {
        return this.moduleScheduler;
    }

    public void setModuleScheduler(ModuleScheduler executionScheduler) {
        this.moduleScheduler = executionScheduler;
    }

    public ExecutorInitializer getExecutorInitializer() {
        return this.executorConfiguration;
    }

    public void setExecutorInitializer(ExecutorInitializer executorConfiguration) {
        this.executorConfiguration = executorConfiguration;
    }

    public Map<String, DataExporter> getModuleExporters() {
        return this.moduleExporters;
    }

    public DataExporter getModuleExporter(String exporterKey) {
        if (this.moduleExporters.containsKey(exporterKey)) {
            return this.moduleExporters.get(exporterKey);
        }
        return null;
    }

    public void setModuleExporters(Map<String, DataExporter> moduleExporters) {
        this.moduleExporters = moduleExporters;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

