/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.export;

import au.com.bytecode.opencsv.CSVWriter;
import ch.tatool.data.DataContainer;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVModuleDataExport {
    Logger logger = LoggerFactory.getLogger(CSVModuleDataExport.class);
    private List<String> baseProperties;
    private int basePropertiesSize;
    private List<String> moduleProperties;
    private int sessionPropertiesSize;

    public CSVModuleDataExport(DataService dataService) {
        this.initBaseProperties();
    }

    public File exportData(Module module) {
        this.initModuleProperties(module);
        try {
            File tmpFile = File.createTempFile("moduleData", "csv");
            FileOutputStream fos = new FileOutputStream(tmpFile, false);
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"), ';');
            ArrayList<String> headers = new ArrayList<String>(this.baseProperties);
            headers.addAll(this.moduleProperties);
            writer.writeNext(headers.toArray(new String[headers.size()]));
            List<String[]> moduleData = this.getDataForModule(module);
            writer.writeAll(moduleData);
            writer.close();
            return tmpFile;
        }
        catch (IOException ioe) {
            this.logger.error("Unable to write csv file", (Throwable)ioe);
            return null;
        }
    }

    private List<String[]> getDataForModule(Module module) {
        ArrayList<String[]> data = new ArrayList<String[]>(this.basePropertiesSize + this.sessionPropertiesSize);
        this.addModuleProperties(module, data);
        return data;
    }

    private void initBaseProperties() {
        this.baseProperties = new ArrayList<String>();
        this.baseProperties.add("Module id");
        this.baseProperties.add("Module name");
        this.basePropertiesSize = this.baseProperties.size();
    }

    private String[] getBaseProperties(Module module) {
        String[] baseProps = new String[]{module.getId().toString(), module.getName()};
        return baseProps;
    }

    private void addToData(List<String[]> data, String[] values) {
        if (values != null) {
            data.add(values);
        }
    }

    private void initModuleProperties(Module module) {
        this.moduleProperties = new ArrayList<String>();
        this.moduleProperties.add("ELEMENT_ID");
        this.moduleProperties.add("PROPERTY_NAME");
        this.moduleProperties.add("PROPERTY_VALUE");
        this.sessionPropertiesSize = this.moduleProperties.size();
    }

    private void addModuleProperties(Module module, List<String[]> data) {
        ArrayList<String> moduleProps = null;
        for (DataContainer.Entry p : module.getEntries()) {
            moduleProps = new ArrayList<String>();
            moduleProps.addAll(Arrays.asList(this.getBaseProperties(module)));
            moduleProps.add(p.getNodeId());
            moduleProps.add(p.getName());
            moduleProps.add(p.getValue());
            this.addToData(data, moduleProps.toArray(new String[moduleProps.size()]));
        }
    }
}

