/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.app.gui.LoginFrame;
import ch.tatool.app.service.UserAccountService;
import ch.tatool.data.Messages;
import ch.tatool.data.UserAccount;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class CreateAccountFrame
extends JFrame {
    private static final long serialVersionUID = 8458295653422189812L;
    private UserAccountService userAccountService;
    private LoginFrame loginFrame;
    private Messages messages;
    private JTextField birthYearText;
    private JButton cancelButton;
    private JButton createButton;
    private JRadioButton femaleRadioButton;
    private ButtonGroup genderButtonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JComboBox langComboBox;
    private JRadioButton maleRadioButton;
    private JTextField usernameText;

    public void init() {
        this.initComponents();
    }

    public void setLoginFrame(LoginFrame loginFrame) {
        this.loginFrame = loginFrame;
    }

    public void initialize() {
        this.pack();
        Dimension size = this.getSize();
        size.height += 20;
        this.setSize(size);
        this.setLocationRelativeTo(null);
        URL iconUrl = this.getClass().getResource("/ch/tatool/app/gui/icon.png");
        Image icon = this.getToolkit().getImage(iconUrl);
        this.setIconImage(icon);
    }

    public void createAccount() {
        String userName = this.usernameText.getText();
        String birthYear = this.birthYearText.getText();
        String sex = null;
        if (CreateAccountFrame.getSelection(this.genderButtonGroup) != null) {
            sex = CreateAccountFrame.getSelection(this.genderButtonGroup).getName();
        }
        if (userName.equals("") || userName == null) {
            JOptionPane.showMessageDialog(this, this.messages.getString("CreateAccountFrame.errorMessage.userNameMissing"), this.messages.getString("General.errorMessage.windowTitle.warning"), 2);
            return;
        }
        HashMap<String, String> accountProperties = new HashMap<String, String>();
        if (!birthYear.equals("") && birthYear != null) {
            accountProperties.put("yearOfBirth", birthYear);
        }
        if (sex != null) {
            accountProperties.put("sex", sex);
        }
        String language = (String)this.langComboBox.getSelectedItem();
        String lang = "en";
        if (language.equals("Deutsch")) {
            lang = "de";
        } else if (language.equals("English")) {
            lang = "en";
        }
        accountProperties.put("userLanguage", lang);
        accountProperties.put("osName", System.getProperty("os.name"));
        accountProperties.put("osArch", System.getProperty("os.arch"));
        accountProperties.put("osVersion", System.getProperty("os.version"));
        accountProperties.put("userHome", System.getProperty("user.home"));
        UserAccount account = this.userAccountService.createAccount(userName, accountProperties, null);
        if (account != null) {
            this.loginFrame.openAccount(account);
        } else {
            JOptionPane.showMessageDialog(this, this.messages.getString("CreateAccountFrame.errorMessage.userNameExists"), this.messages.getString("General.errorMessage.windowTitle.warning"), 2);
        }
    }

    public void cancelAccount() {
        this.usernameText.setText("");
        this.birthYearText.setText("");
        this.genderButtonGroup.clearSelection();
        this.setVisible(false);
    }

    public static AbstractButton getSelection(ButtonGroup group) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (b.getModel() != group.getSelection()) continue;
            return b;
        }
        return null;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }

    private void initComponents() {
        this.genderButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.usernameText = new JTextField();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel4 = new JLabel();
        this.birthYearText = new JTextField();
        this.jLabel8 = new JLabel();
        this.maleRadioButton = new JRadioButton();
        this.femaleRadioButton = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.langComboBox = new JComboBox();
        this.setTitle(this.messages.getString("General.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, this.messages.getString("CreateAccountFrame.labelTitle.newUser"), 0, 0, new Font("Tahoma", 1, 14)));
        this.jLabel1.setText(this.messages.getString("CreateAccountFrame.label.user"));
        this.createButton.setText(this.messages.getString("General.okLabel"));
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAccountFrame.this.createButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(this.messages.getString("General.cancelLabel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAccountFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText(this.messages.getString("CreateAccountFrame.label.birthYear"));
        this.jLabel8.setText(this.messages.getString("CreateAccountFrame.label.sex"));
        this.genderButtonGroup.add(this.maleRadioButton);
        this.maleRadioButton.setText(this.messages.getString("CreateAccountFrame.label.sex.female"));
        this.maleRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAccountFrame.this.maleRadioButtonActionPerformed(evt);
            }
        });
        this.genderButtonGroup.add(this.femaleRadioButton);
        this.femaleRadioButton.setText(this.messages.getString("CreateAccountFrame.label.sex.male"));
        this.femaleRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateAccountFrame.this.femaleRadioButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText(this.messages.getString("CreateAccountFrame.label.language"));
        this.langComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{this.messages.getString("CreateAccountFrame.label.language.German"), this.messages.getString("CreateAccountFrame.label.language.English")}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel8)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.createButton, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.maleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.femaleRadioButton)).addComponent(this.usernameText, -1, 177, Short.MAX_VALUE).addComponent(this.birthYearText, GroupLayout.Alignment.TRAILING, -1, 177, Short.MAX_VALUE).addComponent(this.langComboBox, 0, 177, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.usernameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.birthYearText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.langComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.maleRadioButton).addComponent(this.femaleRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createButton).addComponent(this.cancelButton)).addContainerGap(12, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 10, 11, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void maleRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void femaleRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelAccount();
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        this.createAccount();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CreateAccountFrame().setVisible(true);
            }
        });
    }

    public void setUserAccountService(UserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public UserAccountService getUserAccountService() {
        return this.userAccountService;
    }
}

