/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.gui;

import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.module.ModuleInfoProvider;
import ch.tatool.module.ModuleScheduler;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class ModuleInfoPanel
extends JPanel
implements ModuleInfoProvider {
    private static final long serialVersionUID = -3139781440101816327L;
    private HTMLEditorKit kit = new HTMLEditorKit();
    private Module module;
    private String baseString;
    private String page;
    private String user;
    private Date lastExportDate;
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane;

    public ModuleInfoPanel() {
        this.initComponents();
    }

    public void setHTMLString(String htmlString) {
        URL base = this.getClass().getResource(this.baseString);
        ((HTMLDocument)this.jEditorPane.getDocument()).setBase(base);
        this.jEditorPane.setText(htmlString);
        this.validate();
    }

    public void setHTMLPage(URL url) {
        Document doc = this.kit.createDefaultDocument();
        this.jEditorPane.setDocument(doc);
        try {
            this.jEditorPane.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jEditorPane = new JEditorPane();
        this.setLayout(new GridLayout(1, 1, 1, 0));
        this.jScrollPane.setBorder(null);
        this.jEditorPane.setBorder(null);
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setEditorKit(this.kit);
        this.jEditorPane.setFocusable(false);
        this.jScrollPane.setViewportView(this.jEditorPane);
        this.add(this.jScrollPane);
    }

    public JPanel getModuleInfoPanel() {
        Messages messages;
        Map moduleProperties = this.module.getModuleProperties();
        this.baseString = moduleProperties.containsKey("module.info.base") ? (String)moduleProperties.get("module.info.base") : "/ch/tatool/app/gui/";
        this.page = moduleProperties.containsKey("module.info.page") ? (String)moduleProperties.get("module.info.page") : ((messages = this.module.getMessages()).getLanguage().equals("de") ? "welcome_de.htm" : "welcome.htm");
        this.updateModuleInfo(this.module, null);
        return this;
    }

    public String replaceVariables(String html) {
        ModuleScheduler moduleScheduler;
        Messages messages = this.module.getMessages();
        if (html.indexOf("$user") != -1) {
            this.user = this.module.getUserAccount().getName();
            html = html.replaceAll("\\$user", String.valueOf(this.user));
        }
        if (html.indexOf("$moduleName") != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append("<b>");
            sb.append(messages.getString("ModuleInfoPanel.label.moduleName"));
            sb.append("</b> ");
            sb.append(this.module.getName());
            html = html.replaceAll("\\$moduleName", sb.toString());
        }
        if ((moduleScheduler = this.module.getModuleScheduler()) != null) {
            String numSessions = moduleScheduler.getSchedulerNumSessions(this.module);
            String lastSessionDate = moduleScheduler.getSchedulerLastSessionDate(this.module);
            StringBuilder sb = new StringBuilder();
            sb.append("<b>");
            sb.append(messages.getString("ModuleInfoPanel.label.numSessions"));
            sb.append("</b> ");
            sb.append(" <span class='highlight_red'>");
            sb.append(String.valueOf(numSessions));
            sb.append("</span>");
            html = html.replaceAll("\\$numSessions", sb.toString());
            StringBuilder sb2 = new StringBuilder();
            sb2.append("<b>");
            sb2.append(messages.getString("ModuleInfoPanel.label.lastSession"));
            sb2.append("</b> ");
            sb2.append(String.valueOf(lastSessionDate));
            html = html.replaceAll("\\$lastSessionDate", sb2.toString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<b>");
        sb.append(messages.getString("ModuleInfoPanel.label.lastExport"));
        sb.append("</b> ");
        if (this.lastExportDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            sb.append(dateFormat.format(this.lastExportDate));
        } else {
            sb.append("-");
        }
        html = html.replaceAll("\\$lastExportDate", sb.toString());
        return html;
    }

    private String getHTMLString(String page) {
        InputStream is = this.getClass().getResourceAsStream(this.baseString + page);
        String html = "";
        try {
            html = this.inputStreamToString(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return html;
    }

    private String inputStreamToString(InputStream in) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public void updateModuleInfo(Module module, Date lastExportDate) {
        this.lastExportDate = lastExportDate;
        String html = this.getHTMLString(this.page);
        html = this.replaceVariables(html);
        this.setHTMLString(html);
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

