/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.app.data.TrialImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import ch.tatool.data.Trial;
import ch.tatool.exec.ExecutionData;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionDataImpl
implements ExecutionData {
    Logger logger = LoggerFactory.getLogger(ExecutionDataImpl.class);
    private DataService dataService;
    private boolean closeCurrentSession;
    private Module module;
    private ModuleSession moduleSession;
    private LinkedList<Trial> trials = new LinkedList();

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public boolean openSession() {
        if (this.moduleSession != null) {
            return false;
        }
        this.moduleSession = this.dataService.createSession(this.module);
        this.closeCurrentSession = false;
        return true;
    }

    public void setSessionCompleted(int completed) {
        this.moduleSession.setCompleted(completed);
    }

    public int getSessionCompleted() {
        return this.moduleSession.getCompleted();
    }

    public boolean isCloseSessionRequested() {
        return this.closeCurrentSession && this.moduleSession != null;
    }

    public void closeSession() {
        if (this.moduleSession != null) {
            this.dataService.finishSession(this.moduleSession);
            this.dataService.saveModule(this.module);
            this.moduleSession = null;
            this.closeCurrentSession = false;
        } else {
            this.logger.warn("Closing nonexisting session - should never happen!");
        }
    }

    public void persistTrials() {
        for (Trial t : this.trials) {
            this.dataService.insertTrial(this.moduleSession, t);
        }
        this.dataService.saveSession(this.moduleSession);
        this.dataService.saveModule(this.module);
        this.trials.clear();
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void clear() {
        this.closeCurrentSession = false;
        this.module = null;
        this.moduleSession = null;
        this.trials.clear();
    }

    public boolean isCloseCurrentSession() {
        return this.closeCurrentSession;
    }

    public void setCloseCurrentSession(boolean closeCurrentSession) {
        this.closeCurrentSession = closeCurrentSession;
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleSession getModuleSession() {
        return this.moduleSession;
    }

    public void markSessionEnd() {
        this.setCloseCurrentSession(true);
    }

    public Trial getCreateFirstTrial() {
        if (this.trials.isEmpty()) {
            return this.addTrial();
        }
        return this.trials.getFirst();
    }

    public Trial getCreateLastTrial() {
        if (this.trials.isEmpty()) {
            return this.addTrial();
        }
        return this.trials.getLast();
    }

    public LinkedList<Trial> getTrials() {
        return this.trials;
    }

    public Trial addTrial() {
        TrialImpl trial = new TrialImpl();
        this.addTrial(trial);
        return trial;
    }

    private void addTrial(Trial trial) {
        if (this.trials == null) {
            this.trials = new LinkedList();
        }
        this.trials.add(trial);
    }
}

