/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.app.service.exec.impl.ElementTreeImpl;
import ch.tatool.app.service.exec.impl.ExecutionContextImpl;
import ch.tatool.app.service.exec.impl.ExecutionDataImpl;
import ch.tatool.app.service.exec.impl.ExecutionServiceImpl;
import ch.tatool.app.service.exec.impl.PhaseRunnableManagerImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Module;
import ch.tatool.display.ExecutionDisplay;
import ch.tatool.display.ExecutionDisplayProvider;
import ch.tatool.element.Element;
import ch.tatool.element.ElementTree;
import ch.tatool.element.Executable;
import ch.tatool.element.ExecutionStrategy;
import ch.tatool.exec.ExecutionContext;
import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.Executor;
import ch.tatool.exec.PhaseListenerManager;
import ch.tatool.exec.PhaseRunnable;
import ch.tatool.exec.PhaseRunnableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorImpl
implements Executor {
    private static Logger logger = LoggerFactory.getLogger(ExecutorImpl.class);
    private DataService dataService;
    private ExecutionServiceImpl executionService;
    private ExecutionDisplayProvider executionDisplayProvider;
    private ExecutionContextImpl executionContext = null;
    private volatile boolean continueModule = true;
    private volatile boolean finishCurrentCycle = false;
    private Thread executionThread;
    private ExecutionDataImpl executionData;
    private PhaseRunnableManagerImpl phaseRunnableManager;
    private ExecutionStrategy selectorStrategy;
    private ElementTreeImpl elementTree;
    private volatile Executable currentExecutable;
    private volatile Element currentElement;
    private volatile PhaseRunnable currentPhaseExecutable;

    void setExecutionServiceImpl(ExecutionServiceImpl executionService) {
        this.executionService = executionService;
    }

    void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    void setExecutionDisplayProvider(ExecutionDisplayProvider executionDisplayProvider) {
        this.executionDisplayProvider = executionDisplayProvider;
    }

    public void setup(Module module) {
        this.phaseRunnableManager = new PhaseRunnableManagerImpl();
        this.elementTree = new ElementTreeImpl();
        this.executionData = new ExecutionDataImpl();
        this.executionData.setDataService(this.dataService);
        this.executionData.setModule(module);
    }

    public void execute(boolean blockCallerThread) {
        this.executionThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExecutorImpl.this.runModule();
            }
        });
        this.executionThread.setName("Module execution thread");
        this.executionThread.setDaemon(false);
        this.executionThread.start();
        if (blockCallerThread) {
            while (this.executionThread.isAlive()) {
                try {
                    this.executionThread.join();
                }
                catch (InterruptedException ie) {
                    logger.error("Interrupted while waiting for execution thread to finish", (Throwable)ie);
                }
            }
        }
    }

    private void runModule() {
        ExecutionDisplay display = this.executionDisplayProvider != null ? this.executionDisplayProvider.getExecutionDisplay() : null;
        this.executionContext = new ExecutionContextImpl(this, this.executionData, this.dataService, display);
        this.continueModule = true;
        if (this.executionDisplayProvider != null) {
            this.executionDisplayProvider.open();
        }
        this.setPhaseAndInform(ExecutionPhase.EXECUTION_START);
        while (this.continueModule) {
            this.runElement();
        }
        this.executionData.markSessionEnd();
        this.checkCloseSession();
        this.setPhaseAndInform(ExecutionPhase.EXECUTION_FINISH);
        if (this.executionDisplayProvider != null) {
            this.executionDisplayProvider.destroy();
            this.executionDisplayProvider = null;
        }
        this.executionData.clear();
        this.executionThread = null;
    }

    private void runElement() {
        this.finishCurrentCycle = true;
        this.setPhaseAndInform(ExecutionPhase.PRE_ELEMENT_SELECTION);
        this.continueModule = this.selectorStrategy.updateElementStack((ExecutionContext)this.executionContext);
        this.setPhaseAndInform(ExecutionPhase.POST_ELEMENT_SELECTION);
        if (!this.continueModule) {
            this.executionData.setSessionCompleted(1);
            return;
        }
        Element newElement = this.elementTree.getTop();
        Executable newExecutable = null;
        if (newElement == null) {
            this.continueModule = false;
            return;
        }
        newExecutable = newElement.getExecutable();
        if (newExecutable == null) {
            this.continueModule = false;
            return;
        }
        if (this.finishCurrentCycle) {
            this.checkOpenSession();
        }
        if (this.finishCurrentCycle) {
            this.executePhaseExecutables(ExecutionPhase.PRE_EXECUTABLE_EXECUTION);
        }
        if (this.finishCurrentCycle) {
            this.runExecutable(newElement, newExecutable);
        }
        if (this.finishCurrentCycle) {
            this.executePhaseExecutables(ExecutionPhase.POST_EXECUTABLE_EXECUTION);
        }
        if (this.finishCurrentCycle) {
            this.checkCloseSession();
        }
    }

    private void runExecutable(Element element, Executable executable) {
        this.currentElement = element;
        this.currentExecutable = executable;
        this.setPhaseAndInform(ExecutionPhase.PRE_PROCESS);
        if (this.finishCurrentCycle) {
            this.setPhaseAndInform(ExecutionPhase.EXECUTE_EXECUTABLE);
            executable.setExecutionContext((ExecutionContext)this.executionContext);
            executable.execute();
            executable.setExecutionContext(null);
        }
        if (this.finishCurrentCycle) {
            this.setPhaseAndInform(ExecutionPhase.POST_PROCESS);
        }
        this.executionData.persistTrials();
        this.currentElement.setProperty("executed", (Object)Boolean.TRUE);
        this.currentElement = null;
        this.currentExecutable = null;
    }

    private void checkOpenSession() {
        if (this.executionData.openSession()) {
            this.setPhaseAndInform(ExecutionPhase.SESSION_START);
        }
    }

    private void checkCloseSession() {
        if (this.executionData.isCloseSessionRequested()) {
            this.setPhaseAndInform(ExecutionPhase.SESSION_FINISH);
            this.executionData.closeSession();
        }
    }

    public void setExecutionStrategy(ExecutionStrategy selectorStrategy) {
        this.selectorStrategy = selectorStrategy;
    }

    public ExecutionStrategy getExecutionStrategy() {
        return this.selectorStrategy;
    }

    private void executePhaseExecutables(ExecutionPhase phase) {
        this.executionContext.setPhase(phase);
        for (PhaseRunnableManagerImpl.PhaseRunnableData phaseRunnableData : this.phaseRunnableManager.getPhaseExecutablesData(phase)) {
            if (!this.continueModule || !this.finishCurrentCycle) {
                return;
            }
            this.currentPhaseExecutable = phaseRunnableData.getPhaseExecutable();
            this.currentPhaseExecutable.run((ExecutionContext)this.executionContext);
            this.currentPhaseExecutable = null;
            if (phaseRunnableData.recurring) continue;
            this.phaseRunnableManager.removePhaseExecutable(this.currentPhaseExecutable, phase);
        }
    }

    private void stopModuleImpl() {
        this.finishCurrentCycle = false;
        this.continueModule = false;
        this.stopCurrentCycle();
    }

    private void stopCurrentCycle() {
        PhaseRunnable phaseRunnable;
        Executable executable = this.currentExecutable;
        if (executable != null) {
            logger.info("cancelTask: Cancelling executable " + executable.getId());
            executable.cancel();
        }
        if ((phaseRunnable = this.currentPhaseExecutable) != null) {
            logger.info("stopping current phase executable " + phaseRunnable.toString());
            phaseRunnable.stop();
        }
    }

    private void setPhaseAndInform(ExecutionPhase phase) {
        this.executionContext.setPhase(phase);
        this.executionService.getPhaseListenerManager().informListeners((ExecutionContext)this.executionContext);
        this.elementTree.deliverPhaseEvent(this.executionContext);
    }

    private void stopCurrentElementExecutionImpl() {
        this.finishCurrentCycle = false;
        this.stopCurrentCycle();
    }

    public void stopCurrentElementExecution() {
        this.stopCurrentElementExecutionImpl();
    }

    public void stopExecution() {
        this.stopModuleImpl();
    }

    public PhaseRunnableManager getPhaseRunnableManager() {
        return this.phaseRunnableManager;
    }

    public ElementTree getExecutionTree() {
        return this.elementTree;
    }

    public Element getActiveElement() {
        return this.currentElement;
    }

    public Executable getActiveExecutable() {
        return this.currentExecutable;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public PhaseListenerManager getPhaseListenerManager() {
        return this.executionService.getPhaseListenerManager();
    }
}

