/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.exec.impl;

import ch.tatool.exec.ExecutionPhase;
import ch.tatool.exec.PhaseRunnable;
import ch.tatool.exec.PhaseRunnableManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PhaseRunnableManagerImpl
implements PhaseRunnableManager {
    private Map<ExecutionPhase, List<PhaseRunnableData>> phaseRunnables = new HashMap<ExecutionPhase, List<PhaseRunnableData>>();

    public void clear() {
        this.phaseRunnables.clear();
    }

    public void addPhaseExecutable(PhaseRunnable phaseRunnable, ExecutionPhase phase, boolean recurring) {
        List<PhaseRunnableData> elements = this.phaseRunnables.get(phase);
        if (elements == null) {
            elements = new ArrayList<PhaseRunnableData>();
            this.phaseRunnables.put(phase, elements);
        }
        PhaseRunnableData data = new PhaseRunnableData(phaseRunnable, recurring);
        elements.add(data);
    }

    public void removePhaseExecutable(PhaseRunnable phaseRunnable, ExecutionPhase phase) {
        List<PhaseRunnableData> elements = this.phaseRunnables.get(phase);
        for (PhaseRunnableData data : elements) {
            if (data.getPhaseExecutable() != phaseRunnable) continue;
            elements.remove(data);
            if (!elements.isEmpty()) break;
            this.phaseRunnables.remove(elements);
            break;
        }
    }

    public boolean isRecurring(PhaseRunnable phaseRunnable, ExecutionPhase phase) {
        List<PhaseRunnableData> elements = this.phaseRunnables.get(phase);
        for (PhaseRunnableData data : elements) {
            if (data.getPhaseExecutable() != phaseRunnable) continue;
            return data.recurring;
        }
        return false;
    }

    public List<PhaseRunnable> getPhaseExecutables(ExecutionPhase phase) {
        List<PhaseRunnableData> elements = this.phaseRunnables.get(phase);
        if (elements != null) {
            ArrayList<PhaseRunnable> list = new ArrayList<PhaseRunnable>();
            for (PhaseRunnableData data : elements) {
                list.add(data.phaseRunnable);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<PhaseRunnableData> getPhaseExecutablesData(ExecutionPhase phase) {
        List<PhaseRunnableData> elements = this.phaseRunnables.get(phase);
        if (elements != null) {
            return Collections.unmodifiableList(elements);
        }
        return Collections.emptyList();
    }

    public static class PhaseRunnableData {
        PhaseRunnable phaseRunnable;
        boolean recurring;

        public PhaseRunnableData(PhaseRunnable phaseRunnable, boolean recurring) {
            this.phaseRunnable = phaseRunnable;
            this.recurring = recurring;
        }

        public PhaseRunnable getPhaseExecutable() {
            return this.phaseRunnable;
        }

        public void setPhaseExecutable(PhaseRunnable phaseRunnable) {
            this.phaseRunnable = phaseRunnable;
        }

        public boolean isRecurring() {
            return this.recurring;
        }

        public void setRecurring(boolean recurring) {
            this.recurring = recurring;
        }
    }
}

