/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.app.data.UserAccountImpl;
import ch.tatool.app.service.impl.ModuleDAO;
import ch.tatool.app.service.impl.ModuleInfoImpl;
import ch.tatool.data.DataService;
import ch.tatool.data.Messages;
import ch.tatool.data.Module;
import ch.tatool.data.UserAccount;
import ch.tatool.export.DataExporter;
import ch.tatool.module.ExecutorInitializer;
import ch.tatool.module.ModuleScheduler;
import ch.tatool.module.ModuleService;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ModuleServiceImpl
implements ModuleService {
    Logger logger = LoggerFactory.getLogger(ModuleServiceImpl.class);
    private DataService dataService;
    private Messages messages;

    public Set<Module.Info> getModules(UserAccount account) {
        final UserAccountImpl accountImpl = (UserAccountImpl)account;
        return (Set)accountImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                return accountImpl.getModuleDAO().getModules(accountImpl);
            }
        });
    }

    public Module createModule(UserAccount account, Map<String, String> moduleProperties, Map<String, byte[]> binaryModuleProperties, Map<String, DataExporter> moduleExporters) {
        String moduleName;
        final UserAccountImpl accountImpl = (UserAccountImpl)account;
        final ModuleImpl module = new ModuleImpl();
        module.setAccount(accountImpl);
        module.setAccountId(accountImpl.getId());
        if (moduleProperties != null) {
            module.setModuleProperties(moduleProperties);
        }
        if (binaryModuleProperties != null) {
            module.setBinaryModuleProperties(binaryModuleProperties);
        }
        if (moduleExporters != null) {
            module.setModuleExporters(moduleExporters);
        }
        if ((moduleName = moduleProperties.get("module.name")) == null) {
            this.logger.warn("No module name defined.");
            moduleName = "Module " + System.currentTimeMillis();
            module.getModuleProperties().put("module.name", moduleName);
        }
        module.setName(moduleName);
        accountImpl.getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                accountImpl.getModuleDAO().saveModule(module);
            }
        });
        this.initializeModule(module);
        return module;
    }

    public Module loadModule(Module.Info info) {
        final ModuleInfoImpl moduleInfoImpl = (ModuleInfoImpl)info;
        ModuleImpl module = (ModuleImpl)moduleInfoImpl.getAccount().getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                ModuleDAO moduleDAO = moduleInfoImpl.getAccount().getModuleDAO();
                ModuleImpl module = moduleDAO.loadModule(moduleInfoImpl);
                return module;
            }
        });
        this.initializeModule(module);
        Map<String, DataExporter> exporters = this.getModuleExportersFromXML(module.getBinaryModuleProperty("SpringXmlElementConfig"));
        module.setModuleExporters(exporters);
        return module;
    }

    private void initializeModule(ModuleImpl module) {
        this.loadModuleScheduler(module);
        this.loadInitializer(module);
        this.loadMessages(module);
    }

    private Map<String, DataExporter> getModuleExportersFromXML(byte[] configurationXML) {
        GenericXmlApplicationContext moduleContext = null;
        if (configurationXML != null) {
            try {
                moduleContext = new GenericXmlApplicationContext(new Resource[]{new ByteArrayResource(configurationXML)});
            }
            catch (BeansException be) {
                throw new RuntimeException("Unable to load Tatool file.", be);
            }
            if (moduleContext.containsBean("moduleExporters")) {
                Map exporters = (Map)moduleContext.getBean("moduleExporters");
                return exporters;
            }
            return Collections.emptyMap();
        }
        return null;
    }

    private void loadModuleScheduler(ModuleImpl module) {
        ModuleScheduler scheduler = (ModuleScheduler)this.instantiateObject(module, "module.scheduler.classname", ModuleScheduler.class);
        String maxSessions = module.getModuleProperties().get("module.scheduler.maxSessions");
        if (scheduler != null) {
            scheduler.setModule((Module)module);
            scheduler.setDataService(this.dataService);
            scheduler.initialize();
            if (maxSessions != null) {
                scheduler.setMaxSessions(Integer.valueOf(maxSessions));
            }
            module.setModuleScheduler(scheduler);
        }
    }

    private void loadInitializer(ModuleImpl module) {
        ExecutorInitializer initializer = (ExecutorInitializer)this.instantiateObject(module, "module.execution.initializer.classname", ExecutorInitializer.class);
        if (initializer != null) {
            module.setExecutorInitializer(initializer);
        }
    }

    private void loadMessages(ModuleImpl module) {
        module.setMessages(this.messages);
    }

    private Object instantiateObject(Module module, String propertyName, Class<?> assignableTo) {
        Class<?> c = null;
        String className = (String)module.getModuleProperties().get(propertyName);
        if (className != null && className.length() > 0) {
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                this.logger.warn("Class not found: " + e.getMessage(), (Throwable)e);
            }
        }
        if (c == null) {
            return null;
        }
        if (assignableTo != null && !assignableTo.isAssignableFrom(c)) {
            this.logger.warn("Class " + c.getName() + " is not assigable to class " + assignableTo.getName());
            return null;
        }
        Object o = null;
        try {
            o = c.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.error("Unable to create session scheduler", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Unable to create session scheduler", (Throwable)e);
        }
        return o;
    }

    public void closeModule(Module module) {
    }

    public void saveModule(Module module) {
        this.dataService.saveModule(module);
    }

    public void deleteModule(Module.Info info) {
        final ModuleInfoImpl moduleInfoImpl = (ModuleInfoImpl)info;
        moduleInfoImpl.getAccount().getTransactionTemplate().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(TransactionStatus status) {
                ModuleDAO moduleDAO = moduleInfoImpl.getAccount().getModuleDAO();
                moduleDAO.deleteModule(moduleInfoImpl);
            }
        });
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public Messages getMessages() {
        return this.messages;
    }
}

